# Sistema de Bolão

Sistema PHP para registro e acompanhamento de jogos de bolão, baseado na análise da planilha fornecida.

## Características do Sistema

### Estrutura do Jogo
- **4 Canchas** por jogo (CANCHA 1, 2, 3, 4)
- **5 jogadas** por cancha (total de 20 jogadas por jogo)
- **10 jogos** por sessão
- **Campo Exp**: Registra valor se primeira jogada ≠ 9, mas não conta na média

### Funcionalidades
- Registro automático de data e hora
- Cálculo automático de subtotais e totais
- Controle do campo Exp conforme regra específica
- Histórico completo de sessões e jogos
- Estatísticas acumuladas (TT, TTT, médias)

## Instalação

### Pré-requisitos
- Servidor web com PHP 7.4+
- MySQL 5.7+ ou MariaDB
- Extensões PHP: PDO, PDO_MySQL

### Passos de Instalação

1. **Extrair arquivos**
   ```bash
   unzip sistema_bolao.zip
   cd sistema_bolao
   ```

2. **Configurar banco de dados**
   - Importe o arquivo `database.sql` no MySQL:
   ```sql
   mysql -u root -p < database.sql
   ```

3. **Configurar conexão**
   - Edite o arquivo `includes/config.php`
   - Ajuste as credenciais do banco de dados:
   ```php
   define('DB_HOST', 'localhost');
   define('DB_USER', 'seu_usuario');
   define('DB_PASS', 'sua_senha');
   define('DB_NAME', 'bolao_system');
   ```

4. **Configurar servidor web**
   - Aponte o DocumentRoot para a pasta do sistema
   - Ou coloque os arquivos na pasta htdocs/www do seu servidor

## Uso do Sistema

### Página Principal (index.php)
- Formulário para registro de novos jogos
- Campos obrigatórios: Nome do jogador, Local, Número do jogo
- 4 seções de canchas com 5 jogadas cada
- Cálculo automático de subtotais e totais
- Campo Exp preenchido automaticamente conforme regra

### Página de Resultados (resultados.php)
- Lista todas as sessões de jogo
- Visualização detalhada por sessão
- Tabelas com todas as jogadas
- Estatísticas acumuladas (TTT, médias)
- Resumo por cancha

### Regras Implementadas

1. **Campo Exp**: 
   - Se primeira jogada da cancha ≠ 9: registra o valor
   - Se primeira jogada da cancha = 9: campo fica vazio
   - Valores Exp não contam nas médias

2. **Cálculos**:
   - Subtotal = soma das 5 jogadas da cancha
   - Total C1+C2 = subtotal cancha 1 + subtotal cancha 2
   - Total C3+C4 = subtotal cancha 3 + subtotal cancha 4
   - TT = Total C1+C2 + Total C3+C4
   - TTT = soma acumulada de todos os TT
   - Média = TTT / número de jogos

## Estrutura de Arquivos

```
sistema_bolao/
├── index.php              # Página principal (formulário)
├── resultados.php          # Página de resultados
├── database.sql           # Script de criação do banco
├── README.md              # Este arquivo
├── includes/
│   └── config.php         # Configurações do banco
├── css/
│   └── style.css          # Estilos do sistema
└── js/
    └── bolao.js           # JavaScript para cálculos automáticos
```

## Banco de Dados

### Tabelas Criadas
- **jogadores**: Cadastro de jogadores
- **sessoes**: Sessões de jogo (jogador + local + data)
- **jogos**: Jogos individuais com todas as jogadas
- **estatisticas_sessao**: Estatísticas acumuladas por sessão

## Suporte

Para dúvidas ou problemas:
1. Verifique as configurações do banco de dados
2. Confirme que as extensões PHP estão instaladas
3. Verifique os logs de erro do servidor web

## Versão
1.0 - Sistema completo baseado na análise da planilha de bolão

