# Sistema de Bolão - Completo com Autenticação e Pagamento

Sistema PHP completo para registro e acompanhamento de jogos de bolão, com sistema de autenticação, cadastro de usuários e integração com Stripe para pagamentos.

## 🚀 Funcionalidades Implementadas

### 1. Sistema de Autenticação
- **Login**: Página de login com validação de credenciais
- **Cadastro**: Registro de novos usuários com validação completa
- **Esqueci Senha**: Recuperação de senha com geração automática
- **Logout**: Encerramento seguro de sessão
- **Proteção de Rotas**: Todas as páginas protegidas por autenticação

### 2. Gestão de Usuários
- **Campos Obrigatórios**: Nome, Endereço, CPF, Email, Telefone
- **Validações**: CPF único, email único, senhas seguras
- **Termos de Uso**: Aceitação obrigatória dos termos
- **Perfil**: Página para edição de dados pessoais

### 3. Sistema de Pagamento (Stripe)
- **Mensalidade**: R$ 9,90 por mês
- **Integração Stripe**: Processamento seguro de pagamentos
- **Status de Assinatura**: Controle de acesso baseado em pagamento
- **Histórico**: Registro de todos os pagamentos

### 4. Sistema de Bolão Original
- **4 Canchas** por jogo com 5 jogadas cada
- **10 jogos** por sessão
- **Campo Exp**: Regra específica para primeira jogada ≠ 9
- **Cálculos Automáticos**: Subtotais, totais e médias
- **Histórico Completo**: Todas as sessões e estatísticas

### 5. Dashboard e Navegação
- **Dashboard Principal**: Visão geral do sistema
- **Estatísticas**: Resumo de jogos e sessões
- **Navegação Intuitiva**: Links entre todas as páginas
- **Status Visual**: Indicadores de assinatura ativa/inativa

## 📁 Estrutura de Arquivos

```
projeto_bola/
├── auth/                          # Sistema de autenticação
│   ├── login.php                 # Página de login
│   ├── register.php              # Página de cadastro
│   ├── forgot_password.php       # Recuperação de senha
│   ├── logout.php                # Logout
│   └── terms.php                 # Termos de uso
├── payment/                       # Sistema de pagamento
│   ├── subscription.php          # Página de pagamento
│   ├── process_payment.php       # Processador Stripe
│   └── stripe_integration.md     # Documentação Stripe
├── includes/
│   └── config.php                # Configurações e conexão DB
├── css/
│   └── style.css                 # Estilos do sistema
├── js/
│   └── bolao.js                  # JavaScript para cálculos
├── index.php                     # Formulário de jogos (protegido)
├── resultados.php                # Histórico e estatísticas (protegido)
├── dashboard.php                 # Dashboard principal
├── profile.php                   # Perfil do usuário
├── database.sql                  # Estrutura original do banco
├── database_migration.sql        # Migração para usuários
└── README_SISTEMA_COMPLETO.md    # Esta documentação
```

## 🗄️ Banco de Dados

### Tabelas Principais

#### users (Nova)
```sql
CREATE TABLE users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    address VARCHAR(255) NOT NULL,
    cpf VARCHAR(14) UNIQUE NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    phone VARCHAR(20) NOT NULL,
    password VARCHAR(255) NOT NULL,
    terms_accepted BOOLEAN DEFAULT FALSE,
    subscription_status VARCHAR(50) DEFAULT 'inactive',
    subscription_expires_at TIMESTAMP NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);
```

#### payments (Nova)
```sql
CREATE TABLE payments (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    amount INT NOT NULL,
    currency VARCHAR(3) NOT NULL,
    stripe_charge_id VARCHAR(255),
    status VARCHAR(50) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
);
```

#### jogadores (Modificada)
- Adicionado campo `user_id` para vincular jogadores aos usuários

### Tabelas Originais (Mantidas)
- `sessoes`: Sessões de jogo
- `jogos`: Jogos individuais com todas as jogadas
- `estatisticas_sessao`: Estatísticas acumuladas

## ⚙️ Configuração e Instalação

### 1. Banco de Dados
```bash
# Criar banco e tabelas originais
mysql -u bolao_user -pbolao_password < database.sql

# Aplicar migração para usuários
mysql -u bolao_user -pbolao_password bolao_system < database_migration.sql
```

### 2. Configuração do Stripe
Edite `includes/config.php`:
```php
// Substitua pelas suas chaves reais do Stripe
define('STRIPE_PUBLISHABLE_KEY', 'pk_test_YOUR_PUBLISHABLE_KEY');
define('STRIPE_SECRET_KEY', 'sk_test_YOUR_SECRET_KEY');
```

### 3. Servidor Web
```bash
# Instalar Apache e PHP
sudo apt-get install apache2 php libapache2-mod-php php-mysql

# Copiar arquivos
sudo cp -r projeto_bola/* /var/www/html/
sudo chown -R www-data:www-data /var/www/html/
```

## 🔐 Fluxo de Autenticação

### 1. Primeiro Acesso
1. Usuário acessa qualquer página
2. Redirecionado para `auth/login.php`
3. Clica em "Criar conta"
4. Preenche formulário em `auth/register.php`
5. Aceita termos de uso
6. Conta criada, redirecionado para login

### 2. Login
1. Usuário faz login em `auth/login.php`
2. Credenciais validadas
3. Sessão criada com dados do usuário
4. Redirecionado para `dashboard.php`

### 3. Controle de Acesso
1. Todas as páginas verificam autenticação
2. Páginas do bolão verificam assinatura ativa
3. Usuários sem assinatura são redirecionados para pagamento

## 💳 Sistema de Pagamento

### 1. Fluxo de Pagamento
1. Usuário sem assinatura acessa `payment/subscription.php`
2. Preenche dados do cartão (Stripe Elements)
3. Token enviado para `process_payment.php`
4. Pagamento processado via API Stripe
5. Status atualizado no banco de dados
6. Acesso liberado ao sistema

### 2. Cartões de Teste
- **Sucesso**: 4242 4242 4242 4242
- **Recusado**: 4000 0000 0000 0002
- **CVV Inválido**: 4000 0000 0000 0127

## 🎯 Integração com Sistema Original

### 1. Nome do Jogador
- Campo automaticamente preenchido com nome do usuário logado
- Jogadores vinculados ao usuário através de `user_id`

### 2. Isolamento de Dados
- Cada usuário vê apenas seus próprios jogos
- Filtros aplicados em todas as consultas

### 3. Funcionalidades Mantidas
- Todas as regras originais do bolão preservadas
- Cálculos automáticos funcionando
- Interface original mantida

## 🔧 Recursos Técnicos

### 1. Segurança
- Senhas criptografadas com `password_hash()`
- Validação de sessão em todas as páginas
- Sanitização de dados de entrada
- Proteção contra SQL Injection (PDO)

### 2. Validações
- CPF e email únicos
- Máscaras JavaScript para CPF e telefone
- Validação de força de senha
- Verificação de termos de uso

### 3. Interface
- Design responsivo
- Feedback visual para usuário
- Navegação intuitiva
- Mensagens de erro e sucesso

## 🌐 Acesso ao Sistema

**URL de Teste**: https://80-ibbs8e41bjuuham15dhj8-99e17f75.manusvm.computer

### Teste Rápido
1. Acesse a URL acima
2. Clique em "Criar conta"
3. Preencha o formulário de cadastro
4. Faça login
5. Ative a assinatura (use cartão de teste)
6. Acesse o sistema de bolão

## 📞 Suporte e Manutenção

### 1. Logs
- Erros de pagamento logados em `error_log`
- Sessões e autenticação rastreáveis

### 2. Backup
- Backup regular da tabela `users` e `payments`
- Dados de jogos já protegidos pelo sistema original

### 3. Monitoramento
- Status de assinaturas
- Falhas de pagamento
- Tentativas de login

## 🚀 Próximos Passos

### 1. Produção
- Configurar SSL/HTTPS
- Usar chaves reais do Stripe
- Configurar email real para recuperação de senha
- Implementar webhooks do Stripe

### 2. Melhorias
- Dashboard com mais estatísticas
- Relatórios em PDF
- Notificações de vencimento
- Sistema de convites

---

**Desenvolvido em PHP puro com integração Stripe para pagamentos seguros.**

