<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Acesso Gratuito - Sistema de Bolão</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        .access-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            text-align: center;
        }
        .btn {
            display: inline-block;
            padding: 15px 30px;
            background: #28a745;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            font-size: 18px;
            margin: 10px;
        }
        .btn:hover {
            background: #218838;
        }
        .btn-secondary {
            background: #007bff;
        }
        .btn-secondary:hover {
            background: #0056b3;
        }
        .features {
            text-align: left;
            margin: 30px 0;
        }
        .features ul {
            list-style-type: none;
            padding: 0;
        }
        .features li {
            padding: 10px 0;
            border-bottom: 1px solid #eee;
        }
        .features li:before {
            content: "✓ ";
            color: #28a745;
            font-weight: bold;
        }
    </style>
</head>
<body>
    <div class="access-container">
        <h1>Acesso Gratuito ao Sistema de Bolão</h1>
        
        <p>Experimente gratuitamente todas as funcionalidades do nosso sistema de súmula de bolão!</p>
        
        <div class="features">
            <h3>O que você pode fazer:</h3>
            <ul>
                <li>Registrar jogos completos com 4 canchas</li>
                <li>Calcular automaticamente subtotais e totais</li>
                <li>Visualizar histórico de jogos</li>
                <li>Acompanhar estatísticas pessoais</li>
                <li>Interface baseada na planilha Excel original</li>
            </ul>
        </div>
        
        <p><strong>Teste agora mesmo sem compromisso!</strong></p>
        
        <a href="sumula/index.php" class="btn">Acessar Súmula</a>
        <a href="dashboard.php" class="btn btn-secondary">Voltar ao Dashboard</a>
        
        <div style="margin-top: 30px; padding: 20px; background: #f8f9fa; border-radius: 5px;">
            <h4>Gostou? Assine por apenas R$ 9,90/mês</h4>
            <p>Com a assinatura você garante acesso permanente e suporte técnico.</p>
            <a href="payment/subscription.php" class="btn btn-secondary">Assinar Agora</a>
        </div>
    </div>
</body>
</html>

