<?php
session_start();

// Verificar se o usuário está logado
if (!isset($_SESSION["logged_in"]) || $_SESSION["logged_in"] !== true) {
    header("Location: auth/login.php");
    exit;
}

// Verificar se o pagamento foi bem-sucedido (vindo do process_payment.php)
if (!isset($_GET["payment_success"]) || $_GET["payment_success"] !== "true") {
    // Se não veio de um pagamento bem-sucedido, redirecionar para o dashboard ou sumula
    header("Location: dashboard.php"); // Ou para a sumula diretamente, dependendo do fluxo desejado
    exit;
}

$user_name = $_SESSION["user_name"] ?? "Usuário";

?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Oferta Especial - Sistema de Bolão</title>
    <link rel="stylesheet" href="css/style.css">
    <style>
        body {
            background-color: #f0f2f5;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }
        .ads-container {
            background: linear-gradient(135deg, #6dd5ed, #2193b0);
            color: white;
            padding: 40px;
            border-radius: 15px;
            box-shadow: 0 10px 25px rgba(0, 0, 0, 0.2);
            text-align: center;
            max-width: 600px;
            width: 90%;
            animation: fadeIn 1s ease-out;
        }
        .ads-container h1 {
            font-size: 2.8em;
            margin-bottom: 20px;
            text-shadow: 2px 2px 4px rgba(0,0,0,0.3);
        }
        .ads-container p {
            font-size: 1.2em;
            line-height: 1.6;
            margin-bottom: 30px;
        }
        .ads-container .btn-ads {
            display: inline-block;
            background-color: #ffc107;
            color: #333;
            padding: 15px 30px;
            border-radius: 50px;
            text-decoration: none;
            font-weight: bold;
            font-size: 1.3em;
            transition: background-color 0.3s ease, transform 0.3s ease;
            box-shadow: 0 5px 15px rgba(0,0,0,0.2);
        }
        .ads-container .btn-ads:hover {
            background-color: #e0a800;
            transform: translateY(-3px);
        }
        .ads-container .skip-link {
            display: block;
            margin-top: 20px;
            color: rgba(255, 255, 255, 0.8);
            text-decoration: none;
            font-size: 0.9em;
            transition: color 0.3s ease;
        }
        .ads-container .skip-link:hover {
            color: white;
        }
        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(-20px); }
            to { opacity: 1; transform: translateY(0); }
        }
    </style>
</head>
<body>
    <div class="ads-container">
        <h1>Parabéns, <?php echo htmlspecialchars($user_name); ?>!</h1>
        <p>Seu pagamento foi confirmado com sucesso. Como agradecimento, temos uma oferta exclusiva para você!</p>
        <p>Aproveite <strong>50% de desconto</strong> na sua próxima mensalidade se indicar um amigo que assinar o sistema!</p>
        <a href="sumula/index.php" class="btn-ads">Continuar para a Súmula</a>
        <a href="sumula/index.php" class="skip-link">Não, obrigado. Ir direto para a Súmula.</a>
    </div>
</body>
</html>


