<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Esqueci Minha Senha - Sistema de Bolão</title>
    <link rel="stylesheet" href="../css/gaming-theme.css">
    <style>
        .auth-container {
            max-width: 400px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            color: black;
        }
        .auth-form {
            display: flex;
            flex-direction: column;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        .btn {
            padding: 12px 20px;
            background: #ffc107;
            color: #212529;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background: #e0a800;
        }
        .auth-links {
            text-align: center;
            margin-top: 20px;
        }
        .auth-links a {
            color: #007bff;
            text-decoration: none;
        }
        .auth-links a:hover {
            text-decoration: underline;
        }
        .error {
            color: red;
            margin-bottom: 15px;
            text-align: center;
        }
        .success {
            color: green;
            margin-bottom: 15px;
            text-align: center;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
            text-align: center;
        }
    </style>
</head>
<body>
    <div class="auth-container">
        <h2 style="text-align: center; margin-bottom: 30px;">Esqueci Minha Senha</h2>
        
        <?php
        require_once '../includes/config.php';
        
        $error = '';
        $success = '';
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $email = trim($_POST['email']);
            
            if (empty($email)) {
                $error = 'Por favor, informe seu email.';
            } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $error = 'Email inválido.';
            } else {
                try {
                    $pdo = conectarBanco();
                    $stmt = $pdo->prepare("SELECT id, name FROM users WHERE email = ?");
                    $stmt->execute([$email]);
                    $user = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($user) {
                        // Gerar nova senha temporária
                        $new_password = substr(str_shuffle('abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789'), 0, 8);
                        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                        
                        // Atualizar senha no banco
                        $stmt = $pdo->prepare("UPDATE users SET password = ? WHERE id = ?");
                        $stmt->execute([$hashed_password, $user['id']]);
                        
                        // Aqui você implementaria o envio de email
                        // Por enquanto, vamos simular que foi enviado
                        $success = "Uma nova senha foi gerada e enviada para seu email. Nova senha temporária: <strong>$new_password</strong><br><small>Em um sistema real, isso seria enviado por email.</small>";
                    } else {
                        $error = 'Email não encontrado em nosso sistema.';
                    }
                } catch (PDOException $e) {
                    $error = 'Erro no sistema. Tente novamente.';
                }
            }
        }
        ?>
        
        <div class="info">
            Informe seu email cadastrado e enviaremos uma nova senha temporária.
        </div>
        
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success"><?php echo $success; ?></div>
        <?php else: ?>
            <form method="POST" class="auth-form">
                <div class="form-group">
                    <label for="email">Email:</label>
                    <input type="email" id="email" name="email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>" required>
                </div>
                
                <button type="submit" class="btn">Enviar Nova Senha</button>
            </form>
        <?php endif; ?>
        
        <div class="auth-links">
            <a href="login.php">Voltar ao Login</a>
        </div>
    </div>
</body>
</html>

