<?php
session_start();

// Se já estiver logado, manda para a home/dashboard
if (isset($_SESSION['usuario_id'])) {
    header("Location: ../dashboard.php"); // ou dashboard.php
    exit;
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Sistema de Bolão</title>
    <link rel="stylesheet" href="../css/gaming-theme.css">
    <style>
/* ---------- Configuração geral para footer fixo ---------- */
html, body {
    height: 100%;
    margin: 0;
    padding: 0;
}

body {
    display: flex;
    flex-direction: column;
    min-height: 100vh;
    
}

.container-fluid {
    flex: 1; /* Faz o container ocupar todo o espaço disponível */
    display: flex;
    flex-direction: column;
    align-items: center; /* centraliza horizontalmente */
    justify-content: center; /* centraliza verticalmente quando o conteúdo é pequeno */
}

/* Footer sem margem extra */
footer {
    margin: 0;
}

/* ---------- Estilo do formulário de login ---------- */
.auth-container {
    max-width: 400px;
    width: 90%; /* responsivo para telas pequenas */
    margin: 0 auto; /* centraliza horizontalmente */
    padding: 30px;
    background: #fff;
    border-radius: 10px;
    box-shadow: 0 0 20px rgba(0,0,0,0.1);
}

.auth-form {
    display: flex;
    flex-direction: column;
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #555;
}

.form-group input {
    width: 100%;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

input:focus, select:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    outline: none;
}

.btn {
    padding: 12px 20px;
    background: #007bff;
    color: white;
    border: none;
    border-radius: 5px;
    cursor: pointer;
    font-size: 16px;
}

.btn:hover {
    background: #0056b3;
}

.auth-links {
    text-align: center;
    margin-top: 20px;
}

.auth-links a {
    color: #007bff;
    text-decoration: none;
    margin: 0 10px;
}

.auth-links a:hover {
    text-decoration: underline;
}

.error {
    color: red;
    margin-bottom: 15px;
    text-align: center;
}

.success {
    color: green;
    margin-bottom: 15px;
    text-align: center;
}
</style>

</head>
<body>
     <div class="particles" id="particles"></div>

    <div class="container">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-controller me-3"></i>GAMING BOLÃO</h1>
                <p><i class="bi bi-trophy-fill me-2"></i>Sistema Profissional de Registro de Jogadas</p>
            </div>
    </div>
    <div class="auth-container">
        <h2 style="text-align: center; margin-bottom: 30px; color: blue;">Login</h2>
        
        <?php
        require_once '../includes/config.php';
        
        $error = '';
        $success = '';
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $email = trim($_POST['email']);
            $password = $_POST['password'];
            
            if (empty($email) || empty($password)) {
                $error = 'Por favor, preencha todos os campos.';
            } else {
                try {
                    $pdo = conectarBanco();
                    $stmt = $pdo->prepare("SELECT id, name, password FROM users WHERE email = ?");
                    $stmt->execute([$email]);
                    $user = $stmt->fetch(PDO::FETCH_ASSOC);
                    
                    if ($user && password_verify($password, $user['password'])) {
                        $_SESSION["user_id"] = $user["id"];
                        $_SESSION["user_name"] = $user["name"];
                        $_SESSION["logged_in"] = true;
                        
                        header('Location: ../dashboard.php');
                        exit;
                    } else {
                        $error = 'Email ou senha incorretos.';
                    }
                } catch (PDOException $e) {
                    $error = 'Erro no sistema. Tente novamente.';
                }
            }
        }
        
        if (isset($_GET['msg'])) {
            if ($_GET['msg'] == 'registered') {
                $success = 'Cadastro realizado com sucesso! Faça seu login.';
            } elseif ($_GET['msg'] == 'reset') {
                $success = 'Nova senha enviada para seu email.';
            }
        }
        ?>
        
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <form method="POST" class="auth-form">
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" required>
            </div>
            
            <div class="form-group">
                <label for="password">Senha:</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <button type="submit" class="gaming-btn gaming-btn-success">Entrar</button>
        </form>
        
        <div class="auth-links">
            <a href="register.php">Criar conta</a>
            <a href="forgot_password.php">Esqueci minha senha</a>
        </div>
    </div>
    <?php include '../template/footer.php'; ?>
</body>
</html>

