<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro - Sistema de Bolão</title>
    <link rel="stylesheet" href="../css/gaming-theme.css">
    <style>
        .auth-container {
            max-width: 500px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .auth-form {
            display: flex;
            flex-direction: column;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        .btn {
            padding: 12px 20px;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
        }
        .btn:hover {
            background: #218838;
        }
        .auth-links {
            text-align: center;
            margin-top: 20px;
        }
        .auth-links a {
            color: #007bff;
            text-decoration: none;
        }
        .auth-links a:hover {
            text-decoration: underline;
        }
        .error {
            color: red;
            margin-bottom: 15px;
            text-align: center;
        }
        .terms-group {
            margin: 20px 0;
        }
        .terms-group input[type="checkbox"] {
            width: auto;
            margin-right: 10px;
        }
        .terms-group label {
            display: inline;
            font-weight: normal;
        }
        label {
    display: block;
    margin-bottom: 8px;
    font-weight: bold;
    color: #555;
}

input[type="text"], input[type="number"], input[type="email"], input[type="password"], select {
    width: 100%;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 16px;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

input:focus, select:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    outline: none;
}

    </style>
</head>
<body>
     <div class="particles" id="particles"></div>

    <div class="container-fluid">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-controller me-3"></i>GAMING BOLÃO</h1>
                <p><i class="bi bi-trophy-fill me-2"></i>Sistema Profissional de Registro de Jogadas</p>
            </div>
</div>
    <div class="auth-container">
        <h2 style="text-align: center; margin-bottom: 30px; color: blue;">Cadastro</h2>
        
        <?php
        require_once '../includes/config.php';
        
        $error = '';
        
        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $name = trim($_POST['name']);
            $address = trim($_POST['address']);
            $cpf = trim($_POST['cpf']);
            $email = trim($_POST['email']);
            $phone = trim($_POST['phone']);
            $password = $_POST['password'];
            $confirm_password = $_POST['confirm_password'];
            $terms_accepted = isset($_POST['terms_accepted']);
            
            // Validações
            if (empty($name) || empty($address) || empty($cpf) || empty($email) || empty($phone) || empty($password)) {
                $error = 'Por favor, preencha todos os campos.';
            } elseif ($password !== $confirm_password) {
                $error = 'As senhas não coincidem.';
            } elseif (strlen($password) < 6) {
                $error = 'A senha deve ter pelo menos 6 caracteres.';
            } elseif (!$terms_accepted) {
                $error = 'Você deve aceitar os termos de uso.';
            } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
                $error = 'Email inválido.';
            } else {
                // Remover formatação do CPF
                $cpf = preg_replace('/[^0-9]/', '', $cpf);
                
                if (strlen($cpf) != 11) {
                    $error = 'CPF deve ter 11 dígitos.';
                } else {
                    try {
                        $pdo = conectarBanco();
                        
                        // Verificar se email já existe
                        $stmt = $pdo->prepare("SELECT id FROM users WHERE email = ?");
                        $stmt->execute([$email]);
                        if ($stmt->fetch()) {
                            $error = 'Este email já está cadastrado.';
                        } else {
                            // Verificar se CPF já existe
                            $stmt = $pdo->prepare("SELECT id FROM users WHERE cpf = ?");
                            $stmt->execute([$cpf]);
                            if ($stmt->fetch()) {
                                $error = 'Este CPF já está cadastrado.';
                            } else {
                                // Inserir usuário
                                $hashed_password = password_hash($password, PASSWORD_DEFAULT);
                                $stmt = $pdo->prepare("INSERT INTO users (name, address, cpf, email, phone, password, terms_accepted) VALUES (?, ?, ?, ?, ?, ?, ?)");
                                $stmt->execute([$name, $address, $cpf, $email, $phone, $hashed_password, 1]);
                                
                                header('Location: login.php?msg=registered');
                                exit;
                            }
                        }
                    } catch (PDOException $e) {
                        $error = 'Erro no sistema. Tente novamente.';
                    }
                }
            }
        }
        ?>
        
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <form method="POST" class="auth-form">
            <div class="form-group">
                <label for="name">Nome Completo:</label>
                <input type="text" id="name" name="name" value="<?php echo isset($_POST['name']) ? htmlspecialchars($_POST['name']) : ''; ?>" required>
            </div>
            
            <div class="form-group">
                <label for="address">Endereço:</label>
                <input type="text" id="address" name="address" value="<?php echo isset($_POST['address']) ? htmlspecialchars($_POST['address']) : ''; ?>" required>
            </div>
            
            <div class="form-group">
                <label for="cpf">CPF:</label>
                <input type="text" id="cpf" name="cpf" value="<?php echo isset($_POST['cpf']) ? htmlspecialchars($_POST['cpf']) : ''; ?>" placeholder="000.000.000-00" required>
            </div>
            
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" value="<?php echo isset($_POST['email']) ? htmlspecialchars($_POST['email']) : ''; ?>" required>
            </div>
            
            <div class="form-group">
                <label for="phone">Telefone:</label>
                <input type="text" id="phone" name="phone" value="<?php echo isset($_POST['phone']) ? htmlspecialchars($_POST['phone']) : ''; ?>" placeholder="(00) 00000-0000" required>
            </div>
            
            <div class="form-group">
                <label for="password">Senha:</label>
                <input type="password" id="password" name="password" required>
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Confirmar Senha:</label>
                <input type="password" id="confirm_password" name="confirm_password" required>
            </div>
            
            <div class="terms-group">
                <input type="checkbox" id="terms_accepted" name="terms_accepted" required>
                <label for="terms_accepted">Aceito os <a href="terms.php" target="_blank">termos de uso</a></label>
            </div>
            
            <button type="submit" class="btn">Cadastrar</button>
        </form>
        
        <div class="auth-links">
            <a href="login.php">Já tenho uma conta</a>
        </div>
    </div>
    
    <script>
        // Máscara para CPF
        document.getElementById('cpf').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d)/, '$1.$2');
            value = value.replace(/(\d{3})(\d{1,2})$/, '$1-$2');
            e.target.value = value;
        });
        
        // Máscara para telefone
        document.getElementById('phone').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/(\d{2})(\d)/, '($1) $2');
            value = value.replace(/(\d{5})(\d)/, '$1-$2');
            e.target.value = value;
        });
    </script>
</body>
</html>

