<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Termos de Uso - Sistema de Bolão</title>
    <link rel="stylesheet" href="../css/style.css">
    <style>
        .terms-container {
            max-width: 800px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
        }
        .terms-content {
            line-height: 1.6;
        }
        .terms-content h3 {
            color: #333;
            margin-top: 30px;
            margin-bottom: 15px;
        }
        .terms-content p {
            margin-bottom: 15px;
            text-align: justify;
        }
        .back-link {
            text-align: center;
            margin-top: 30px;
        }
        .back-link a {
            color: #007bff;
            text-decoration: none;
            padding: 10px 20px;
            border: 1px solid #007bff;
            border-radius: 5px;
        }
        .back-link a:hover {
            background: #007bff;
            color: white;
        }
    </style>
</head>
<body>
    <div class="terms-container">
        <h1 style="text-align: center; margin-bottom: 30px;">Termos de Uso</h1>
        
        <div class="terms-content">
            <h3>1. Aceitação dos Termos</h3>
            <p>Ao utilizar o Sistema de Bolão, você concorda em cumprir e estar vinculado a estes Termos de Uso. Se você não concordar com qualquer parte destes termos, não deve usar nosso serviço.</p>
            
            <h3>2. Descrição do Serviço</h3>
            <p>O Sistema de Bolão é uma plataforma online que permite aos usuários registrar e acompanhar jogos de bolão, incluindo estatísticas e histórico de jogadas.</p>
            
            <h3>3. Cadastro e Conta do Usuário</h3>
            <p>Para utilizar nossos serviços, você deve criar uma conta fornecendo informações precisas e completas. Você é responsável por manter a confidencialidade de sua senha e por todas as atividades que ocorrem em sua conta.</p>
            
            <h3>4. Pagamento e Mensalidade</h3>
            <p>O acesso completo ao sistema requer o pagamento de uma mensalidade de R$ 9,90. Os pagamentos são processados através do Stripe e devem estar em dia para manter o acesso aos serviços.</p>
            
            <h3>5. Uso Aceitável</h3>
            <p>Você concorda em usar o serviço apenas para fins legais e de acordo com estes Termos. É proibido:</p>
            <ul>
                <li>Usar o serviço para qualquer propósito ilegal ou não autorizado</li>
                <li>Interferir ou interromper o serviço ou servidores conectados ao serviço</li>
                <li>Tentar obter acesso não autorizado ao serviço</li>
            </ul>
            
            <h3>6. Privacidade</h3>
            <p>Respeitamos sua privacidade e protegemos suas informações pessoais de acordo com nossa Política de Privacidade. Coletamos apenas as informações necessárias para fornecer nossos serviços.</p>
            
            <h3>7. Propriedade Intelectual</h3>
            <p>Todo o conteúdo do Sistema de Bolão, incluindo textos, gráficos, logos e software, é propriedade nossa ou de nossos licenciadores e está protegido por leis de direitos autorais.</p>
            
            <h3>8. Limitação de Responsabilidade</h3>
            <p>O serviço é fornecido "como está" sem garantias de qualquer tipo. Não seremos responsáveis por quaisquer danos diretos, indiretos, incidentais ou consequenciais resultantes do uso do serviço.</p>
            
            <h3>9. Cancelamento</h3>
            <p>Você pode cancelar sua conta a qualquer momento. Reservamo-nos o direito de suspender ou encerrar contas que violem estes Termos de Uso.</p>
            
            <h3>10. Alterações nos Termos</h3>
            <p>Podemos atualizar estes Termos de Uso periodicamente. Continuando a usar o serviço após as alterações, você aceita os novos termos.</p>
            
            <h3>11. Contato</h3>
            <p>Se você tiver dúvidas sobre estes Termos de Uso, entre em contato conosco através do email: contato@sistemabol ao.com</p>
            
            <p><strong>Data de última atualização:</strong> <?php echo date('d/m/Y'); ?></p>
        </div>
        
        <div class="back-link">
            <a href="javascript:history.back()">Voltar</a>
        </div>
    </div>
</body>
</html>

