<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Sistema de Bolão</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Gaming Theme CSS -->
    <link href="css/gaming-theme.css" rel="stylesheet">
</head>
<body>
    <!-- Particle Background -->
    <div class="particles" id="particles"></div>

    <div class="container-fluid">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-controller me-3"></i>GAMING BOLÃO</h1>
                <p><i class="bi bi-trophy-fill me-2"></i>Sistema Profissional de Registro de Jogadas</p>
            </div>

            <div class="container-fluid p-4">
                <!-- Gaming Alert -->
                <?php if (isset($_GET['payment']) && $_GET['payment'] === 'success'): ?>
                    <div class="gaming-alert alert-success alert-dismissible fade show" role="alert">
                        <i class="bi bi-check-circle-fill me-2"></i>
                        <strong>Pagamento realizado com sucesso!</strong> Sua assinatura está ativa.
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>
                
                <?php if (!$subscription_active): ?>
                    <div class="gaming-alert alert-danger alert-dismissible fade show" role="alert">
                        <i class="bi bi-exclamation-triangle-fill me-2"></i>
                        <strong>Assinatura Inativa!</strong> Para acessar todas as funcionalidades do sistema, é necessário ativar sua assinatura mensal.
                        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                    </div>
                <?php endif; ?>

                <!-- Gaming Navigation -->
                <div class="gaming-nav">
                    <a href="sumula/index.php">
                        <i class="bi bi-plus-circle-fill me-2"></i>Novo Jogo
                    </a>
                    <a href="sumula/resultados_user.php">
                        <i class="bi bi-bar-chart-fill me-2"></i>Resultados
                    </a>
                    <a href="sumula/resultados.php">
                        <i class="bi bi-trophy me-2"></i>Ranking
                    </a>
                </div>



                <div class="row row-cols-1 row-cols-md-2 g-4">
                    <div class="col">
                        <div class="gaming-card">
                            <div class="card-body text-center">
                                <h3 class="card-title" style="padding: 1rem;"><i class="bi bi-controller me-2"></i>Novo Jogo</h3>
                                <p class="card-text" style="padding: 1rem;">Registre um novo jogo de bolão com todas as jogadas.</p>
                                <?php if ($subscription_active): ?>
                                    <a href="sumula/index.php" class="gaming-btn gaming-btn-success">Iniciar Jogo</a>
                                <?php else: ?>
                                    <a href="sumula/index.php" class="gaming-btn gaming-btn-success">Acesso Gratuito</a>
                                    
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="gaming-card">
                            <div class="card-body text-center">
                                <h3 class="card-title" style="padding: 1rem;"><i class="bi bi-bar-chart-line-fill me-2"></i>Histórico</h3>
                                <p class="card-text" style="padding: 1rem;">Visualize o histórico completo de suas sessões e estatísticas.</p>
                                <?php if ($subscription_active): ?>
                                    <a href="sumula/resultados_user.php" class="gaming-btn">Ver Resultados</a>
                                <?php else: ?>
                                    <a href="payment/subscription.php" class="gaming-btn gaming-btn-warning">Ativar Assinatura</a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="gaming-card">
                            <div class="card-body text-center">
                                <h3 class="card-title" style="padding: 1rem;"><i class="bi bi-credit-card-fill me-2"></i>Pagamento</h3>
                                <p class="card-text" style="padding: 1rem;">Gerencie sua assinatura e histórico de pagamentos.</p>
                                <a href="payment/subscription.php" class="gaming-btn <?php echo $subscription_active ? '' : 'gaming-btn-warning'; ?>">
                                    <?php echo $subscription_active ? 'Renovar Assinatura' : 'Ativar Assinatura'; ?>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col">
                        <div class="gaming-card">
                            <div class="card-body text-center">
                                <h3 class="card-title" style="padding: 1rem;"><i class="bi bi-person-circle me-2"></i>Perfil</h3>
                                <p class="card-text" style="padding: 1rem;">Atualize suas informações pessoais e configurações da conta.</p>
                                <a href="profile.php" class="gaming-btn">Editar Perfil</a>
                            </div>
                        </div>
                    </div>
                </div>

                <?php if ($subscription_active && $subscription_expires): ?>
                    <div class="text-center text-muted mt-4">
                        <small>Assinatura válida até: <?php echo date('d/m/Y H:i', strtotime($subscription_expires)); ?></small>
                    </div>
                <?php endif; ?>
                <a href="auth/logout.php" class="gaming-btn gaming-btn-success">Sair</a>
            </div>
        </div>
    </div>
    

<?php include 'template/footer.php'; ?>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Particle effect (from gaming-theme.css)
        const particlesContainer = document.getElementById('particles');
        for (let i = 0; i < 50; i++) {
            const particle = document.createElement('div');
            particle.classList.add('particle');
            particle.style.left = `${Math.random() * 100}%`;
            particle.style.top = `${Math.random() * 100}%`;
            particle.style.animationDelay = `${Math.random() * 6}s`;
            particlesContainer.appendChild(particle);
        }

        // Animated counters (example for dashboard stats)
        function animateValue(id, start, end, duration) {
            if (start === end) return;
            const range = end - start;
            let current = start;
            const increment = end > start ? 1 : -1;
            const stepTime = Math.abs(Math.floor(duration / range));
            const obj = document.getElementById(id);
            if (!obj) return; // Check if element exists

            const timer = setInterval(() => {
                current += increment;
                obj.textContent = current;
                if (current == end) {
                    clearInterval(timer);
                }
            }, stepTime);
        }

        // Animate stats on load
        document.addEventListener('DOMContentLoaded', () => {
            animateValue('totalSessoes', 0, <?php echo $stats['total_sessoes'] ?? 0; ?>, 2000);
            animateValue('totalJogos', 0, <?php echo $jogos_stats['total_jogos'] ?? 0; ?>, 2000);

            // Calculate and display days remaining for subscription
            const subscriptionExpires = '<?php echo $subscription_expires; ?>';
            if (subscriptionExpires) {
                const expiryDate = new Date(subscriptionExpires);
                const today = new Date();
                const diffTime = expiryDate - today;
                const diffDays = Math.ceil(diffTime / (1000 * 60 * 60 * 24));
                const diasRestantesElement = document.getElementById('diasRestantes');
                if (diasRestantesElement) {
                    diasRestantesElement.textContent = diffDays > 0 ? diffDays : 0;
                }
            }
        });
    </script>
</body>
</html>

