-- Tabela de usuários para o sistema de autenticação
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    name VARCHAR(255) NOT NULL,
    address VARCHAR(255) NOT NULL,
    cpf VARCHAR(14) UNIQUE NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    phone VARCHAR(20) NOT NULL,
    password VARCHAR(255) NOT NULL,
    terms_accepted BOOLEAN DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
);

-- Adicionar um campo user_id na tabela jogadores para vincular com a tabela users
ALTER TABLE jogadores ADD COLUMN user_id INT NULL;
ALTER TABLE jogadores ADD CONSTRAINT fk_user_id FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE SET NULL;

-- Se houver jogadores existentes, podemos tentar associá-los a usuários ou deixá-los sem user_id por enquanto.
-- Por exemplo, se o nome do jogador for único e puder ser usado como e-mail ou parte dele:
-- UPDATE jogadores j JOIN users u ON j.nome = u.name SET j.user_id = u.id;


