<?php
require_once '../includes/config.php';
require_once '../vendor/autoload.php';

// Verificar se usuário está logado
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    http_response_code(401);
    echo json_encode(['success' => false, 'error' => 'Usuário não autenticado']);
    exit;
}

// Verificar se é uma requisição POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'error' => 'Método não permitido']);
    exit;
}

// Ler dados JSON
$input = json_decode(file_get_contents('php://input'), true);

if (!$input || !isset($input['token'])) {
    http_response_code(400);
    echo json_encode(['success' => false, 'error' => 'Dados inválidos']);
    exit;
}

// Configurar cabeçalho para JSON
header('Content-Type: application/json');

try {
    // Configurar Stripe com a chave real
    $stripeSecretKey = 'sk_test_51S78YgBCxXbxzgzOwlan9rIOhKeMkNxhenni3s7sfTbW25jeKubtknnoRM0Ez731mUKOLtzdA3kv1qd0ywwpLYWm0045UXeAOi';
    \Stripe\Stripe::setApiKey($stripeSecretKey);
    
    $token = $input['token'];
    $amount = $input['amount'] ?? 990; // R$ 9,90 em centavos
    $currency = $input['currency'] ?? 'brl';
    $description = $input['description'] ?? 'Mensalidade Sistema de Bolão';
    
    // Buscar informações do usuário
    $pdo = conectarBanco();
    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
    $stmt->execute([$_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$user) {
        echo json_encode(['success' => false, 'error' => 'Usuário não encontrado']);
        exit;
    }
    
    // Processar pagamento com Stripe
    $charge = \Stripe\Charge::create([
        'amount' => $amount,
        'currency' => $currency,
        'description' => $description,
        'source' => $token,
        'metadata' => [
            'user_id' => $_SESSION['user_id'],
            'user_email' => $user['email']
        ]
    ]);
    
    $charge_id = $charge->id;
    $payment_success = ($charge->status === 'succeeded');
    
    if ($payment_success) {
        // Criar tabela de pagamentos se não existir
        $pdo->exec("
            CREATE TABLE IF NOT EXISTS payments (
                id INT AUTO_INCREMENT PRIMARY KEY,
                user_id INT NOT NULL,
                amount INT NOT NULL,
                currency VARCHAR(3) NOT NULL,
                stripe_charge_id VARCHAR(255),
                status VARCHAR(50) NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
            )
        ");
        
        // Registrar pagamento no banco de dados
        $stmt = $pdo->prepare("
            INSERT INTO payments (user_id, amount, currency, stripe_charge_id, status, created_at) 
            VALUES (?, ?, ?, ?, 'completed', NOW())
        ");
        $stmt->execute([$_SESSION['user_id'], $amount, $currency, $charge_id]);
        
        // Adicionar colunas de assinatura se não existirem
        try {
            $pdo->exec("ALTER TABLE users ADD COLUMN subscription_status VARCHAR(50) DEFAULT 'inactive'");
        } catch (PDOException $e) {
            // Coluna já existe
        }
        
        try {
            $pdo->exec("ALTER TABLE users ADD COLUMN subscription_expires_at TIMESTAMP NULL");
        } catch (PDOException $e) {
            // Coluna já existe
        }
        
        // Atualizar status de pagamento do usuário
        $expires_at = date('Y-m-d H:i:s', strtotime('+1 month'));
        $stmt = $pdo->prepare("
            UPDATE users 
            SET subscription_status = 'active', subscription_expires_at = ? 
            WHERE id = ?
        ");
        $stmt->execute([$expires_at, $_SESSION['user_id']]);
        
        echo json_encode([
            'success' => true,
            'charge_id' => $charge_id,
            'message' => 'Pagamento processado com sucesso!',
            'redirect_url' => '../ads.php?payment_success=true' // Redirecionar para a página de ADS
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'error' => 'Falha no processamento do pagamento'
        ]);
    }
    
} catch(\Stripe\Exception\CardException $e) {
    echo json_encode(['success' => false, 'error' => $e->getError()->message]);
} catch (\Stripe\Exception\RateLimitException $e) {
    echo json_encode(['success' => false, 'error' => 'Muitas requisições']);
} catch (\Stripe\Exception\InvalidRequestException $e) {
    echo json_encode(['success' => false, 'error' => 'Parâmetros inválidos']);
} catch (\Stripe\Exception\AuthenticationException $e) {
    echo json_encode(['success' => false, 'error' => 'Erro de autenticação']);
} catch (\Stripe\Exception\ApiConnectionException $e) {
    echo json_encode(['success' => false, 'error' => 'Erro de conexão']);
} catch (\Stripe\Exception\ApiErrorException $e) {
    echo json_encode(['success' => false, 'error' => 'Erro da API']);
} catch (Exception $e) {
    error_log("Erro no pagamento: " . $e->getMessage());
    echo json_encode([
        'success' => false,
        'error' => 'Erro interno do servidor'
    ]);
}
?>

