<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pagamento da Mensalidade - Sistema de Bolão</title>
    <link rel="stylesheet" href="../css/gaming-theme.css">
    <script src="https://js.stripe.com/v3/"></script>
    <style>
        .payment-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            color: #333;
        }
        .subscription-info {
            background: #f8f9fa;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 30px;
            text-align: center;
        }
        .price {
            font-size: 2.5em;
            color: #28a745;
            font-weight: bold;
            margin: 10px 0;
        }
        .features {
            list-style: none;
            padding: 0;
            margin: 20px 0;
        }
        .features li {
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .features li:before {
            content: "✓ ";
            color: #28a745;
            font-weight: bold;
        }
        .payment-form {
            margin-top: 30px;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        #card-element {
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            background: white;
        }
        .btn {
            width: 100%;
            padding: 15px;
            background: #28a745;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 18px;
            font-weight: bold;
        }
        .btn:hover {
            background: #218838;
        }
        .btn:disabled {
            background: #6c757d;
            cursor: not-allowed;
        }
        .error {
            color: red;
            margin-top: 10px;
            text-align: center;
        }
        .success {
            color: green;
            margin-top: 10px;
            text-align: center;
        }
        .loading {
            display: none;
            text-align: center;
            margin-top: 10px;
        }
        .user-info {
            background: #e9ecef;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <?php
    require_once '../includes/config.php';
    
    // Verificar se usuário está logado
    if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
        header('Location: ../auth/login.php');
        exit;
    }
    
    // Buscar informações do usuário
    try {
        $pdo = conectarBanco();
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$user) {
            header('Location: ../auth/login.php');
            exit;
        }
    } catch (PDOException $e) {
        die("Erro no sistema.");
    }
    ?>
    
    <div class="payment-container">
        <h2 style="text-align: center; margin-bottom: 30px;">Pagamento da Mensalidade</h2>
        
        <div class="user-info">
            <strong>Usuário:</strong> <?php echo htmlspecialchars($user['name']); ?><br>
            <strong>Email:</strong> <?php echo htmlspecialchars($user['email']); ?>
        </div>
        
        <div class="subscription-info">
            <h3>Plano Mensal</h3>
            <div class="price">R$ 19,90</div>
            <p>Acesso completo ao Sistema de Bolão</p>
            
            <ul class="features">
                <li>Registro ilimitado de jogos</li>
                <li>Histórico completo de sessões</li>
                <li>Estatísticas detalhadas</li>
                <li>Cálculos automáticos</li>
                <li>Suporte técnico</li>
            </ul>
        </div>
        
        <form id="payment-form" class="payment-form">
            <div class="form-group">
                <label for="cardholder-name">Nome no Cartão:</label>
                <input type="text" id="cardholder-name" name="cardholder_name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="card-element">Informações do Cartão:</label>
                <div id="card-element">
                    <!-- Stripe Elements irá criar os campos do cartão aqui -->
                </div>
            </div>
            
            <button type="submit" id="submit-button" class="btn">
                Pagar R$ 19,90
            </button>
            
            <div id="card-errors" class="error"></div>
            <div id="payment-success" class="success"></div>
            <div id="loading" class="loading">Processando pagamento...</div>
        </form>
        
        <div style="text-align: center; margin-top: 20px;">
            <a href="../dashboard.php">Voltar ao Dashboard</a>
        </div>
        <div style="text-align: center; margin-top: 20px;">
            <a href="../sumula/">Acesso Gratis</a>
        </div>
    </div>
    
    <script>
        // Configurar Stripe (substitua pela sua chave pública real)
        const stripe = Stripe('pk_test_YOUR_PUBLISHABLE_KEY');
        const elements = stripe.elements();
        
        // Criar elemento do cartão
        const cardElement = elements.create('card', {
            style: {
                base: {
                    fontSize: '16px',
                    color: '#424770',
                    '::placeholder': {
                        color: '#aab7c4',
                    },
                },
            },
        });
        
        cardElement.mount('#card-element');
        
        // Lidar com erros em tempo real
        cardElement.on('change', function(event) {
            const displayError = document.getElementById('card-errors');
            if (event.error) {
                displayError.textContent = event.error.message;
            } else {
                displayError.textContent = '';
            }
        });
        
        // Lidar com o envio do formulário
        const form = document.getElementById('payment-form');
        form.addEventListener('submit', async function(event) {
            event.preventDefault();
            
            const submitButton = document.getElementById('submit-button');
            const loading = document.getElementById('loading');
            const errorElement = document.getElementById('card-errors');
            const successElement = document.getElementById('payment-success');
            
            // Desabilitar botão e mostrar loading
            submitButton.disabled = true;
            loading.style.display = 'block';
            errorElement.textContent = '';
            successElement.textContent = '';
            
            // Criar token do cartão
            const {token, error} = await stripe.createToken(cardElement, {
                name: document.getElementById('cardholder-name').value,
            });
            
            if (error) {
                // Mostrar erro
                errorElement.textContent = error.message;
                submitButton.disabled = false;
                loading.style.display = 'none';
            } else {
                // Enviar token para o servidor
                fetch('process_payment.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/json',
                    },
                    body: JSON.stringify({
                        token: token.id,
                        amount: 990, // R$ 9,90 em centavos
                        currency: 'brl',
                        description: 'Mensalidade Sistema de Bolão'
                    })
                })
                .then(response => response.json())
                .then(data => {
                    loading.style.display = 'none';
                    
                    if (data.success) {
                        successElement.textContent = 'Pagamento realizado com sucesso!';
                        setTimeout(() => {
                            window.location.href = data.redirect_url || '../ads.php?payment_success=true';
                        }, 2000);
                    } else {
                        errorElement.textContent = data.error || 'Erro no processamento do pagamento.';
                        submitButton.disabled = false;
                    }
                })
                .catch(error => {
                    loading.style.display = 'none';
                    errorElement.textContent = 'Erro de conexão. Tente novamente.';
                    submitButton.disabled = false;
                });
            }
        });
    </script>
</body>
</html>

