<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil - Sistema de Bolão</title>
    <link rel="stylesheet" href="css/gaming-theme.css">
    <style>
        .profile-container {
            max-width: 600px;
            margin: 50px auto;
            padding: 30px;
            background: #fff;
            border-radius: 10px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            color: #333;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        .form-group input {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 5px;
            font-size: 16px;
        }
        .btn {
            padding: 12px 25px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            text-decoration: none;
            display: inline-block;
        }
        .btn:hover {
            background: #0056b3;
        }
        .btn-success {
            background: #28a745;
        }
        .btn-success:hover {
            background: #218838;
        }
        .error {
            color: red;
            margin-bottom: 15px;
            text-align: center;
        }
        .success {
            color: green;
            margin-bottom: 15px;
            text-align: center;
        }
        .navigation {
            text-align: center;
            margin-bottom: 30px;
        }
        .navigation a {
            margin: 0 10px;
        }
    </style>
</head>
<body>
    <?php
    require_once 'includes/config.php';
    
    // Verificar se usuário está logado
    if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
        header('Location: auth/login.php');
        exit;
    }
    
    $error = '';
    $success = '';
    
    // Buscar informações do usuário
    try {
        $pdo = conectarBanco();
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
        $stmt->execute([$_SESSION['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if (!$user) {
            header('Location: auth/login.php');
            exit;
        }
    } catch (PDOException $e) {
        die("Erro no sistema.");
    }
    
    // Processar formulário se enviado
    if ($_SERVER['REQUEST_METHOD'] == 'POST') {
        $name = trim($_POST['name']);
        $address = trim($_POST['address']);
        $phone = trim($_POST['phone']);
        $current_password = $_POST['current_password'];
        $new_password = $_POST['new_password'];
        $confirm_password = $_POST['confirm_password'];
        
        // Validações básicas
        if (empty($name) || empty($address) || empty($phone)) {
            $error = 'Por favor, preencha todos os campos obrigatórios.';
        } else {
            try {
                // Se uma nova senha foi fornecida
                if (!empty($new_password)) {
                    if (empty($current_password)) {
                        $error = 'Informe sua senha atual para alterar a senha.';
                    } elseif (!password_verify($current_password, $user['password'])) {
                        $error = 'Senha atual incorreta.';
                    } elseif ($new_password !== $confirm_password) {
                        $error = 'As novas senhas não coincidem.';
                    } elseif (strlen($new_password) < 6) {
                        $error = 'A nova senha deve ter pelo menos 6 caracteres.';
                    } else {
                        // Atualizar com nova senha
                        $hashed_password = password_hash($new_password, PASSWORD_DEFAULT);
                        $stmt = $pdo->prepare("UPDATE users SET name = ?, address = ?, phone = ?, password = ? WHERE id = ?");
                        $stmt->execute([$name, $address, $phone, $hashed_password, $_SESSION['user_id']]);
                        $success = 'Perfil e senha atualizados com sucesso!';
                        $_SESSION['user_name'] = $name; // Atualizar nome na sessão
                    }
                } else {
                    // Atualizar apenas dados pessoais
                    $stmt = $pdo->prepare("UPDATE users SET name = ?, address = ?, phone = ? WHERE id = ?");
                    $stmt->execute([$name, $address, $phone, $_SESSION['user_id']]);
                    $success = 'Perfil atualizado com sucesso!';
                    $_SESSION['user_name'] = $name; // Atualizar nome na sessão
                }
                
                // Recarregar dados do usuário
                if ($success) {
                    $stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
                    $stmt->execute([$_SESSION['user_id']]);
                    $user = $stmt->fetch(PDO::FETCH_ASSOC);
                }
                
            } catch (PDOException $e) {
                $error = 'Erro no sistema. Tente novamente.';
            }
        }
    }
    ?>
     <div class="particles" id="particles"></div>

    <div class="container-fluid">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-controller me-3"></i>GAMING BOLÃO</h1>
                <p><i class="bi bi-trophy-fill me-2"></i>Sistema Profissional de Registro de Jogadas</p>
            </div>
    </div>  
    </div>
    <div class="profile-container">
        <h2 style="text-align: center; margin-bottom: 30px;">Meu Perfil</h2>
        
        <div class="navigation">
            <a href="dashboard.php" class="btn btn-primary">Dashboard</a>

            <a href="sumula/resultados.php" class="btn btn-primary">Resultados</a>
        </div>
        
        <?php if ($error): ?>
            <div class="error"><?php echo $error; ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success"><?php echo $success; ?></div>
        <?php endif; ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="name">Nome Completo:</label>
                <input type="text" id="name" name="name" value="<?php echo htmlspecialchars($user['name']); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="address">Endereço:</label>
                <input type="text" id="address" name="address" value="<?php echo htmlspecialchars($user['address']); ?>" required>
            </div>
            
            <div class="form-group">
                <label for="cpf">CPF:</label>
                <input type="text" id="cpf" name="cpf" value="<?php echo htmlspecialchars($user['cpf']); ?>" readonly style="background: #f8f9fa;">
                <small style="color: #666;">O CPF não pode ser alterado.</small>
            </div>
            
            <div class="form-group">
                <label for="email">Email:</label>
                <input type="email" id="email" name="email" value="<?php echo htmlspecialchars($user['email']); ?>" readonly style="background: #f8f9fa;">
                <small style="color: #666;">O email não pode ser alterado.</small>
            </div>
            
            <div class="form-group">
                <label for="phone">Telefone:</label>
                <input type="text" id="phone" name="phone" value="<?php echo htmlspecialchars($user['phone']); ?>" required>
            </div>
            
            <hr style="margin: 30px 0;">
            
            <h3>Alterar Senha (opcional)</h3>
            
            <div class="form-group">
                <label for="current_password">Senha Atual:</label>
                <input type="password" id="current_password" name="current_password">
            </div>
            
            <div class="form-group">
                <label for="new_password">Nova Senha:</label>
                <input type="password" id="new_password" name="new_password">
            </div>
            
            <div class="form-group">
                <label for="confirm_password">Confirmar Nova Senha:</label>
                <input type="password" id="confirm_password" name="confirm_password">
            </div>
            
            <button type="submit" class="btn btn-success">Atualizar Perfil</button>
        </form>
        <a href="dashboard.php" class="btn btn-primary" style="margin-top: 20px; display: inline-block;">Voltar ao Dashboard</a>
    </div>
    <?php include 'template/footer.php'; ?>
    <script>
        // Máscara para telefone
        document.getElementById('phone').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            value = value.replace(/(\d{2})(\d)/, '($1) $2');
            value = value.replace(/(\d{5})(\d)/, '$1-$2');
            e.target.value = value;
        });
    </script>
</body>
</html>

