<?php
session_start();
require_once 'includes/config.php';

// Verificar se o usuário está logado
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: auth/login.php');
    exit;
}

// Verificar se assinatura está ativa
$pdo = conectarBanco();
$stmt = $pdo->prepare("SELECT subscription_status FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if ((!$user || $user["subscription_status"] !== "active") && (!isset($_SESSION["free_access"]) || $_SESSION["free_access"] !== true)) {
    header("Location: payment/subscription.php");
    exit;
}

$ranking = [];
$erro = '';

try {
    $pdo = conectarBanco();
    
    // Selecionar os melhores jogadores (com os maiores TTT acumulados)
    // Considerando que 'ttt_acumulado' é a soma total dos pontos de todos os jogos de uma sessão
    // E que um jogador pode ter múltiplas sessões, somamos os TTT de todas as sessões do jogador.
    $stmt = $pdo->prepare("
        SELECT 
            j.nome as jogador_nome,
            SUM(es.ttt_acumulado) as total_pontos,
            COUNT(DISTINCT s.id) as total_sessoes,
            SUM(es.jogos_jogados) as total_jogos
        FROM jogadores j
        JOIN sessoes s ON j.id = s.jogador_id
        JOIN estatisticas_sessao es ON s.id = es.sessao_id
        WHERE j.user_id = ?
        GROUP BY j.id, j.nome
        ORDER BY total_pontos DESC, total_jogos DESC
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $ranking = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (Exception $e) {
    $erro = "Erro ao carregar o ranking: " . $e->getMessage();
}

?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Ranking de Jogadores - Sistema de Bolão</title>
    <link rel="stylesheet" href="css/style.css">
</head>
<body>
    <header>
        <h1>Ranking de Jogadores</h1>
        <p>Melhores Resultados</p>
    </header>

    <div class="container">
        <div class="navigation">
            <a href="dashboard.php" class="btn">Voltar ao Dashboard</a>
        </div>

        <?php if ($erro): ?>
            <div class="alert alert-error"><?php echo $erro; ?></div>
        <?php endif; ?>

        <div class="form-container">
            <h2>Top Jogadores</h2>
            <?php if (empty($ranking)): ?>
                <p>Nenhum jogador encontrado no ranking para o seu usuário.</p>
            <?php else: ?>
                <table class="results-table">
                    <thead>
                        <tr>
                            <th>Posição</th>
                            <th>Jogador</th>
                            <th>Total de Pontos (TTT)</th>
                            <th>Total de Sessões</th>
                            <th>Total de Jogos</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $posicao = 1; foreach ($ranking as $jogador): ?>
                            <tr>
                                <td><?php echo $posicao++; ?></td>
                                <td><?php echo htmlspecialchars($jogador['jogador_nome']); ?></td>
                                <td><?php echo $jogador['total_pontos']; ?></td>
                                <td><?php echo $jogador['total_sessoes']; ?></td>
                                <td><?php echo $jogador['total_jogos']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>


