<?php
require_once 'includes/config.php';

// Verificar se usuário está logado
if (!isset($_SESSION['logged_in']) || !$_SESSION['logged_in']) {
    header('Location: auth/login.php');
    exit;
}

// Verificar se assinatura está ativa
$pdo = conectarBanco();
$stmt = $pdo->prepare("SELECT subscription_status FROM users WHERE id = ?");
$stmt->execute([$_SESSION['user_id']]);
$user = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$user || $user['subscription_status'] !== 'active') {
    header('Location: payment/subscription.php');
    exit;
}

try {
    $pdo = conectarBanco();
    
    // Buscar todas as sessões com estatísticas do usuário logado
    $stmt = $pdo->prepare("
        SELECT 
            s.id as sessao_id,
            j.nome as jogador,
            s.local_jogo,
            s.data_jogo,
            s.hora_jogo,
            es.ttt_acumulado,
            es.jogos_jogados,
            es.media_geral
        FROM sessoes s
        JOIN jogadores j ON s.jogador_id = j.id
        LEFT JOIN estatisticas_sessao es ON s.id = es.sessao_id
        WHERE j.user_id = ?
        ORDER BY s.data_jogo DESC, s.hora_jogo DESC
    ");
    $stmt->execute([$_SESSION['user_id']]);
    $sessoes = $stmt->fetchAll();
    
    // Buscar jogos detalhados se uma sessão for selecionada
    $jogos_detalhados = [];
    $sessao_selecionada = null;
    if (isset($_GET['sessao_id'])) {
        $sessao_id = $_GET['sessao_id'];
        
        $stmt = $pdo->prepare("
            SELECT 
                numero_jogo,
                exp_cancha1, exp_cancha2, exp_cancha3, exp_cancha4,
                cancha1_jog1, cancha1_jog2, cancha1_jog3, cancha1_jog4, cancha1_jog5,
                cancha2_jog1, cancha2_jog2, cancha2_jog3, cancha2_jog4, cancha2_jog5,
                cancha3_jog1, cancha3_jog2, cancha3_jog3, cancha3_jog4, cancha3_jog5,
                cancha4_jog1, cancha4_jog2, cancha4_jog3, cancha4_jog4, cancha4_jog5,
                subtotal_cancha1, subtotal_cancha2, subtotal_cancha3, subtotal_cancha4,
                total_canchas12, total_canchas34, tt_total,
                created_at
            FROM jogos 
            WHERE sessao_id = ? 
            ORDER BY numero_jogo
        ");
        $stmt->execute([$sessao_id]);
        $jogos_detalhados = $stmt->fetchAll();
        
        // Buscar informações da sessão
        $stmt = $pdo->prepare("
            SELECT s.*, j.nome as jogador_nome 
            FROM sessoes s 
            JOIN jogadores j ON s.jogador_id = j.id 
            WHERE s.id = ?
        ");
        $stmt->execute([$sessao_id]);
        $sessao_selecionada = $stmt->fetch();
    }
    
} catch (Exception $e) {
    $erro = "Erro ao buscar dados: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Resultados - Sistema de Bolão</title>
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Bootstrap Icons -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <!-- Gaming Theme CSS -->
    <link href="css/gaming-theme.css" rel="stylesheet">
</head>
<body>
    <!-- Particle Background -->
    <div class="particles" id="particles"></div>

    <div class="container-fluid">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-bar-chart-fill me-3"></i>Resultados do Bolão</h1>
                <p><i class="bi bi-clock-history me-2"></i>Histórico de Jogos e Estatísticas</p>
            </div>

            <div class="container-fluid p-4">
                <!-- Gaming Navigation -->
                <div class="gaming-nav">
                    <a href="index.php">
                        <i class="bi bi-plus-circle-fill me-2"></i>Novo Jogo
                    </a>
                    <a href="dashboard.php">
                        <i class="bi bi-speedometer2 me-2"></i>Dashboard
                    </a>
                    <?php if (isset($_GET["sessao_id"])): ?>
                        <a href="resultados.php">
                            <i class="bi bi-arrow-left-circle-fill me-2"></i>Voltar às Sessões
                        </a>
                    <?php endif; ?>
                </div>

        <?php if (isset($erro)): ?>
            <div class="alert alert-error"><?php echo $erro; ?></div>
        <?php endif; ?>

        <?php if (!isset($_GET['sessao_id'])): ?>
            <!-- Lista de Sessões -->
            <div class="form-container">
                <h2>Sessões de Jogo</h2>
                <?php if (empty($sessoes)): ?>
                    <p>Nenhuma sessão encontrada. <a href="index.php">Registre o primeiro jogo!</a></p>
                <?php else: ?>
                    <table class="results-table">
                        <thead>
                            <tr>
                                <th>Jogador</th>
                                <th>Local</th>
                                <th>Data</th>
                                <th>Hora</th>
                                <th>Jogos</th>
                                <th>TTT Total</th>
                                <th>Média</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($sessoes as $sessao): ?>
                                <tr>
                                    <td><?php echo htmlspecialchars($sessao['jogador']); ?></td>
                                    <td><?php echo htmlspecialchars($sessao['local_jogo']); ?></td>
                                    <td><?php echo date('d/m/Y', strtotime($sessao['data_jogo'])); ?></td>
                                    <td><?php echo date('H:i', strtotime($sessao['hora_jogo'])); ?></td>
                                    <td><?php echo $sessao['jogos_jogados'] ?: 0; ?></td>
                                    <td><?php echo $sessao['ttt_acumulado'] ?: 0; ?></td>
                                    <td><?php echo number_format($sessao['media_geral'] ?: 0, 2); ?></td>
                                    <td>
                                        <a href="?sessao_id=<?php echo $sessao['sessao_id']; ?>" class="btn">Ver Detalhes</a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>

        <?php else: ?>
            <!-- Detalhes da Sessão -->
            <?php if ($sessao_selecionada): ?>
                <div class="form-container">
                    <h2>Detalhes da Sessão</h2>
                    <div class="totals-grid">
                        <div class="total-item">
                            <div class="total-label">Jogador</div>
                            <div class="total-value"><?php echo htmlspecialchars($sessao_selecionada['jogador_nome']); ?></div>
                        </div>
                        <div class="total-item">
                            <div class="total-label">Local</div>
                            <div class="total-value"><?php echo htmlspecialchars($sessao_selecionada['local_jogo']); ?></div>
                        </div>
                        <div class="total-item">
                            <div class="total-label">Data/Hora</div>
                            <div class="total-value">
                                <?php echo date('d/m/Y H:i', strtotime($sessao_selecionada['data_jogo'] . ' ' . $sessao_selecionada['hora_jogo'])); ?>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endif; ?>

            <!-- Jogos Detalhados -->
            <div class="form-container">
                <h2>Jogos da Sessão</h2>
                <?php if (empty($jogos_detalhados)): ?>
                    <p>Nenhum jogo encontrado para esta sessão.</p>
                <?php else: ?>
                    <div style="overflow-x: auto;">
                        <table class="results-table">
                            <thead>
                                <tr>
                                    <th rowspan="2">Jogo</th>
                                    <th colspan="6">CANCHA 1</th>
                                    <th colspan="6">CANCHA 2</th>
                                    <th colspan="6">CANCHA 3</th>
                                    <th colspan="6">CANCHA 4</th>
                                    <th rowspan="2">TT</th>
                                    <th rowspan="2">Data/Hora</th>
                                </tr>
                                <tr>
                                    <th>Exp</th><th>1</th><th>2</th><th>3</th><th>4</th><th>5</th>
                                    <th>Exp</th><th>6</th><th>7</th><th>8</th><th>9</th><th>10</th>
                                    <th>Exp</th><th>11</th><th>12</th><th>13</th><th>14</th><th>15</th>
                                    <th>Exp</th><th>16</th><th>17</th><th>18</th><th>19</th><th>20</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $ttt_acumulado = 0;
                                foreach ($jogos_detalhados as $jogo): 
                                    $ttt_acumulado += $jogo['tt_total'];
                                ?>
                                    <tr>
                                        <td><strong><?php echo $jogo['numero_jogo']; ?></strong></td>
                                        
                                        <!-- Cancha 1 -->
                                        <td style="background-color: #fff3cd;"><?php echo $jogo['exp_cancha1'] ?: '-'; ?></td>
                                        <td><?php echo $jogo['cancha1_jog1']; ?></td>
                                        <td><?php echo $jogo['cancha1_jog2']; ?></td>
                                        <td><?php echo $jogo['cancha1_jog3']; ?></td>
                                        <td><?php echo $jogo['cancha1_jog4']; ?></td>
                                        <td><?php echo $jogo['cancha1_jog5']; ?></td>
                                        
                                        <!-- Cancha 2 -->
                                        <td style="background-color: #fff3cd;"><?php echo $jogo['exp_cancha2'] ?: '-'; ?></td>
                                        <td><?php echo $jogo['cancha2_jog1']; ?></td>
                                        <td><?php echo $jogo['cancha2_jog2']; ?></td>
                                        <td><?php echo $jogo['cancha2_jog3']; ?></td>
                                        <td><?php echo $jogo['cancha2_jog4']; ?></td>
                                        <td><?php echo $jogo['cancha2_jog5']; ?></td>
                                        
                                        <!-- Cancha 3 -->
                                        <td style="background-color: #fff3cd;"><?php echo $jogo['exp_cancha3'] ?: '-'; ?></td>
                                        <td><?php echo $jogo['cancha3_jog1']; ?></td>
                                        <td><?php echo $jogo['cancha3_jog2']; ?></td>
                                        <td><?php echo $jogo['cancha3_jog3']; ?></td>
                                        <td><?php echo $jogo['cancha3_jog4']; ?></td>
                                        <td><?php echo $jogo['cancha3_jog5']; ?></td>
                                        
                                        <!-- Cancha 4 -->
                                        <td style="background-color: #fff3cd;"><?php echo $jogo['exp_cancha4'] ?: '-'; ?></td>
                                        <td><?php echo $jogo['cancha4_jog1']; ?></td>
                                        <td><?php echo $jogo['cancha4_jog2']; ?></td>
                                        <td><?php echo $jogo['cancha4_jog3']; ?></td>
                                        <td><?php echo $jogo['cancha4_jog4']; ?></td>
                                        <td><?php echo $jogo['cancha4_jog5']; ?></td>
                                        
                                        <td><strong><?php echo $jogo['tt_total']; ?></strong></td>
                                        <td><?php echo date('d/m H:i', strtotime($jogo['created_at'])); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                            <tfoot>
                                <tr style="background-color: #e8f5e8; font-weight: bold;">
                                    <td colspan="25">TTT (Total Acumulado)</td>
                                    <td><?php echo $ttt_acumulado; ?></td>
                                    <td>Média: <?php echo number_format($ttt_acumulado / count($jogos_detalhados), 2); ?></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>

                    <!-- Resumo por Cancha -->
                    <div class="totals-section" style="margin-top: 2rem;">
                        <h3>Resumo por Cancha</h3>
                        <table class="results-table">
                            <thead>
                                <tr>
                                    <th>Jogo</th>
                                    <th>Subtotal C1</th>
                                    <th>Subtotal C2</th>
                                    <th>Total C1+C2</th>
                                    <th>Subtotal C3</th>
                                    <th>Subtotal C4</th>
                                    <th>Total C3+C4</th>
                                    <th>TT</th>
                                    <th>TTT Acum.</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php 
                                $ttt_running = 0;
                                foreach ($jogos_detalhados as $jogo): 
                                    $ttt_running += $jogo['tt_total'];
                                ?>
                                    <tr>
                                        <td><?php echo $jogo['numero_jogo']; ?></td>
                                        <td><?php echo $jogo['subtotal_cancha1']; ?></td>
                                        <td><?php echo $jogo['subtotal_cancha2']; ?></td>
                                        <td><?php echo $jogo['total_canchas12']; ?></td>
                                        <td><?php echo $jogo['subtotal_cancha3']; ?></td>
                                        <td><?php echo $jogo['subtotal_cancha4']; ?></td>
                                        <td><?php echo $jogo['total_canchas34']; ?></td>
                                        <td><strong><?php echo $jogo['tt_total']; ?></strong></td>
                                        <td><strong><?php echo $ttt_running; ?></strong></td>
                                    </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                    </div>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    </div>
</body>
</html>

