// Função para calcular subtotais automaticamente
function calcularSubtotal(cancha) {
    let total = 0;
    for (let i = 1; i <= 5; i++) {
        const valor = parseInt(document.getElementById(`cancha${cancha}_jog${i}`).value) || 0;
        total += valor;
    }
    document.getElementById(`subtotal_cancha${cancha}`).value = total;
    calcularTotaisGerais();
}

// Função para calcular totais gerais
function calcularTotaisGerais() {
    const subtotal1 = parseInt(document.getElementById('subtotal_cancha1').value) || 0;
    const subtotal2 = parseInt(document.getElementById('subtotal_cancha2').value) || 0;
    const subtotal3 = parseInt(document.getElementById('subtotal_cancha3').value) || 0;
    const subtotal4 = parseInt(document.getElementById('subtotal_cancha4').value) || 0;
    
    const total12 = subtotal1 + subtotal2;
    const total34 = subtotal3 + subtotal4;
    const tt = total12 + total34;
    
    document.getElementById('total_canchas12').value = total12;
    document.getElementById('total_canchas34').value = total34;
    document.getElementById('tt_total').value = tt;
}

// Função para verificar campo Exp
function verificarExp(cancha) {
    const primeiraJogada = parseInt(document.getElementById(`cancha${cancha}_jog1`).value) || 0;
    const expField = document.getElementById(`exp_cancha${cancha}`);
    
    if (primeiraJogada !== 9) {
        expField.value = primeiraJogada;
        expField.style.backgroundColor = '#fff3cd';
    } else {
        expField.value = '';
        expField.style.backgroundColor = '#ffffff';
    }
}

// Função para validar entrada (0-9)
function validarEntrada(input) {
    let valor = parseInt(input.value);
    if (isNaN(valor) || valor < 0) {
        input.value = 0;
    } else if (valor > 9) {
        input.value = 9;
    }
}

// Adicionar event listeners quando a página carregar
document.addEventListener('DOMContentLoaded', function() {
    // Adicionar listeners para todas as jogadas
    for (let cancha = 1; cancha <= 4; cancha++) {
        for (let jog = 1; jog <= 5; jog++) {
            const input = document.getElementById(`cancha${cancha}_jog${jog}`);
            if (input) {
                input.addEventListener('input', function() {
                    validarEntrada(this);
                    if (jog === 1) {
                        verificarExp(cancha);
                    }
                    calcularSubtotal(cancha);
                });
            }
        }
    }
    
    // Calcular totais iniciais
    for (let cancha = 1; cancha <= 4; cancha++) {
        calcularSubtotal(cancha);
    }
});

// Função para confirmar envio do formulário
function confirmarEnvio() {
    const nome = document.getElementById('nome_jogador').value;
    const local = document.getElementById('local_jogo').value;
    const numeroJogo = document.getElementById('numero_jogo').value;
    
    if (!nome || !local || !numeroJogo) {
        alert('Por favor, preencha todos os campos obrigatórios!');
        return false;
    }
    
    return confirm('Deseja salvar este jogo?');
}

