-- Banco de dados para Sistema de Bolão
CREATE DATABASE IF NOT EXISTS bolao_system CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE bolao_system;

-- Tabela de jogadores
CREATE TABLE IF NOT EXISTS jogadores (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(100) NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
);

-- Tabela de sessões de jogo
CREATE TABLE IF NOT EXISTS sessoes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    jogador_id INT NOT NULL,
    local_jogo VARCHAR(100) NOT NULL,
    data_jogo DATE NOT NULL,
    hora_jogo TIME NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (jogador_id) REFERENCES jogadores(id) ON DELETE CASCADE
);

-- Tabela de jogos individuais
CREATE TABLE IF NOT EXISTS jogos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    sessao_id INT NOT NULL,
    numero_jogo INT NOT NULL, -- 1 a 10
    
    -- Campos Exp para cada cancha
    exp_cancha1 INT DEFAULT NULL,
    exp_cancha2 INT DEFAULT NULL,
    exp_cancha3 INT DEFAULT NULL,
    exp_cancha4 INT DEFAULT NULL,
    
    -- Jogadas Cancha 1 (5 jogadas)
    cancha1_jog1 INT DEFAULT 0,
    cancha1_jog2 INT DEFAULT 0,
    cancha1_jog3 INT DEFAULT 0,
    cancha1_jog4 INT DEFAULT 0,
    cancha1_jog5 INT DEFAULT 0,
    
    -- Jogadas Cancha 2 (5 jogadas)
    cancha2_jog1 INT DEFAULT 0,
    cancha2_jog2 INT DEFAULT 0,
    cancha2_jog3 INT DEFAULT 0,
    cancha2_jog4 INT DEFAULT 0,
    cancha2_jog5 INT DEFAULT 0,
    
    -- Jogadas Cancha 3 (5 jogadas)
    cancha3_jog1 INT DEFAULT 0,
    cancha3_jog2 INT DEFAULT 0,
    cancha3_jog3 INT DEFAULT 0,
    cancha3_jog4 INT DEFAULT 0,
    cancha3_jog5 INT DEFAULT 0,
    
    -- Jogadas Cancha 4 (5 jogadas)
    cancha4_jog1 INT DEFAULT 0,
    cancha4_jog2 INT DEFAULT 0,
    cancha4_jog3 INT DEFAULT 0,
    cancha4_jog4 INT DEFAULT 0,
    cancha4_jog5 INT DEFAULT 0,
    
    -- Campos calculados
    subtotal_cancha1 INT DEFAULT 0,
    subtotal_cancha2 INT DEFAULT 0,
    subtotal_cancha3 INT DEFAULT 0,
    subtotal_cancha4 INT DEFAULT 0,
    total_canchas12 INT DEFAULT 0,
    total_canchas34 INT DEFAULT 0,
    tt_total INT DEFAULT 0, -- Total do jogo
    
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (sessao_id) REFERENCES sessoes(id) ON DELETE CASCADE
);

-- Tabela para estatísticas acumuladas por sessão
CREATE TABLE IF NOT EXISTS estatisticas_sessao (
    id INT AUTO_INCREMENT PRIMARY KEY,
    sessao_id INT NOT NULL,
    ttt_acumulado INT DEFAULT 0, -- Total Total Total (soma de todos os TT)
    jogos_jogados INT DEFAULT 0,
    media_geral DECIMAL(10,2) DEFAULT 0.00,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (sessao_id) REFERENCES sessoes(id) ON DELETE CASCADE
);

-- Inserir alguns dados de exemplo
INSERT INTO jogadores (nome) VALUES 
('João Silva'),
('Maria Santos'),
('Pedro Oliveira');

