<?php
session_start();
require_once '../includes/config.php';

$mensagem = '';
$tipo_mensagem = '';

// Verificar se o usuário está logado
$user_name = '';
if (isset($_SESSION['logged_in']) && $_SESSION['logged_in'] === true) {
    $user_name = $_SESSION['user_name'] ?? '';
}

// Processar formulário se enviado
if ($_POST) {
    try {
        $pdo = conectarBanco();
        
        // Inserir ou buscar jogador
        $user_id = $_SESSION["user_id"];
        $user_name = $_SESSION["user_name"];

        // Inserir ou buscar jogador associado ao user_id
        $stmt = $pdo->prepare("SELECT id FROM jogadores WHERE user_id = ?");
        $stmt->execute([$user_id]);
        $jogador = $stmt->fetch();
        
        if (!$jogador) {
            $stmt = $pdo->prepare("INSERT INTO jogadores (nome, user_id) VALUES (?, ?)");
            $stmt->execute([$user_name, $user_id]);
            $jogador_id = $pdo->lastInsertId();
        } else {
            $jogador_id = $jogador["id"];
        }
        
        // Inserir ou buscar sessão
        $data_atual = date('Y-m-d');
        $hora_atual = date('H:i:s');
        
        $stmt = $pdo->prepare("SELECT id FROM sessoes WHERE jogador_id = ? AND local_jogo = ? AND data_jogo = ?");
        $stmt->execute([$jogador_id, $_POST['local_jogo'], $data_atual]);
        $sessao = $stmt->fetch();
        
        if (!$sessao) {
            $stmt = $pdo->prepare("INSERT INTO sessoes (jogador_id, local_jogo, data_jogo, hora_jogo) VALUES (?, ?, ?, ?)");
            $stmt->execute([$jogador_id, $_POST['local_jogo'], $data_atual, $hora_atual]);
            $sessao_id = $pdo->lastInsertId();
        } else {
            $sessao_id = $sessao['id'];
        }
        
        // Calcular totais
        $subtotal_cancha1 = $_POST['cancha1_jog1'] + $_POST['cancha1_jog2'] + $_POST['cancha1_jog3'] + $_POST['cancha1_jog4'] + $_POST['cancha1_jog5'];
        $subtotal_cancha2 = $_POST['cancha2_jog1'] + $_POST['cancha2_jog2'] + $_POST['cancha2_jog3'] + $_POST['cancha2_jog4'] + $_POST['cancha2_jog5'];
        $subtotal_cancha3 = $_POST['cancha3_jog1'] + $_POST['cancha3_jog2'] + $_POST['cancha3_jog3'] + $_POST['cancha3_jog4'] + $_POST['cancha3_jog5'];
        $subtotal_cancha4 = $_POST['cancha4_jog1'] + $_POST['cancha4_jog2'] + $_POST['cancha4_jog3'] + $_POST['cancha4_jog4'] + $_POST['cancha4_jog5'];
        
        $total_canchas12 = $subtotal_cancha1 + $subtotal_cancha2;
        $total_canchas34 = $subtotal_cancha3 + $subtotal_cancha4;
        $tt_total = $total_canchas12 + $total_canchas34;
        
        // Verificar campos Exp
        $exp_cancha1 = ($_POST['cancha1_jog1'] != 9) ? $_POST['cancha1_jog1'] : null;
        $exp_cancha2 = ($_POST['cancha2_jog1'] != 9) ? $_POST['cancha2_jog1'] : null;
        $exp_cancha3 = ($_POST['cancha3_jog1'] != 9) ? $_POST['cancha3_jog1'] : null;
        $exp_cancha4 = ($_POST['cancha4_jog1'] != 9) ? $_POST['cancha4_jog1'] : null;
        
        // Inserir jogo
        $stmt = $pdo->prepare("
            INSERT INTO jogos (
                sessao_id, numero_jogo, 
                exp_cancha1, exp_cancha2, exp_cancha3, exp_cancha4,
                cancha1_jog1, cancha1_jog2, cancha1_jog3, cancha1_jog4, cancha1_jog5,
                cancha2_jog1, cancha2_jog2, cancha2_jog3, cancha2_jog4, cancha2_jog5,
                cancha3_jog1, cancha3_jog2, cancha3_jog3, cancha3_jog4, cancha3_jog5,
                cancha4_jog1, cancha4_jog2, cancha4_jog3, cancha4_jog4, cancha4_jog5,
                subtotal_cancha1, subtotal_cancha2, subtotal_cancha3, subtotal_cancha4,
                total_canchas12, total_canchas34, tt_total
            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)
        ");
        
        $stmt->execute([
            $sessao_id, $_POST['numero_jogo'],
            $exp_cancha1, $exp_cancha2, $exp_cancha3, $exp_cancha4,
            $_POST['cancha1_jog1'], $_POST['cancha1_jog2'], $_POST['cancha1_jog3'], $_POST['cancha1_jog4'], $_POST['cancha1_jog5'],
            $_POST['cancha2_jog1'], $_POST['cancha2_jog2'], $_POST['cancha2_jog3'], $_POST['cancha2_jog4'], $_POST['cancha2_jog5'],
            $_POST['cancha3_jog1'], $_POST['cancha3_jog2'], $_POST['cancha3_jog3'], $_POST['cancha3_jog4'], $_POST['cancha3_jog5'],
            $_POST['cancha4_jog1'], $_POST['cancha4_jog2'], $_POST['cancha4_jog3'], $_POST['cancha4_jog4'], $_POST['cancha4_jog5'],
            $subtotal_cancha1, $subtotal_cancha2, $subtotal_cancha3, $subtotal_cancha4,
            $total_canchas12, $total_canchas34, $tt_total
        ]);
        
        // Atualizar estatísticas da sessão
        $stmt = $pdo->prepare("
            SELECT SUM(tt_total) as ttt_acumulado, COUNT(*) as jogos_jogados 
            FROM jogos WHERE sessao_id = ?
        ");
        $stmt->execute([$sessao_id]);
        $stats = $stmt->fetch();
        
        $media_geral = $stats['jogos_jogados'] > 0 ? $stats['ttt_acumulado'] / $stats['jogos_jogados'] : 0;
        
        $stmt = $pdo->prepare("
            INSERT INTO estatisticas_sessao (sessao_id, ttt_acumulado, jogos_jogados, media_geral) 
            VALUES (?, ?, ?, ?) 
            ON DUPLICATE KEY UPDATE 
            ttt_acumulado = VALUES(ttt_acumulado), 
            jogos_jogados = VALUES(jogos_jogados), 
            media_geral = VALUES(media_geral)
        ");
        $stmt->execute([$sessao_id, $stats['ttt_acumulado'], $stats['jogos_jogados'], $media_geral]);
        
        $mensagem = "Jogo salvo com sucesso!";
        $tipo_mensagem = "success";
        
    } catch (Exception $e) {
        $mensagem = "Erro ao salvar: " . $e->getMessage();
        $tipo_mensagem = "error";
    }
}
?>

<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Sistema de Bolão</title>
    
    <link rel="stylesheet" href="../css/gaming-theme.css">
</head>
<style>
    label {
    display: block;
    margin-bottom: 8px;
    font-weight: bold;
    color: #555;
}

input[type="text"], input[type="number"], input[type="email"], input[type="password"], select {
    width: 100%;
    padding: 12px;
    border: 1px solid #ccc;
    border-radius: 8px;
    font-size: 16px;
    transition: border-color 0.3s ease, box-shadow 0.3s ease;
}

input:focus, select:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 3px rgba(0, 123, 255, 0.25);
    outline: none;
}


  /* Mantém o estilo do .jogada-input para inputs e selects */
  .jogada-input {
    width: 80px;               /* mesma largura que os inputs */
    padding: 6px;
    font-size: 16px;
    border: 1px solid rgba(255, 255, 255, 0.2);
    border-radius: 8px;
    background: var(--bg-card, #1a1a1a); /* usa a variável ou cor padrão */
    color: #007bff;
    text-align: center;
    cursor: pointer;
    appearance: none;
    -webkit-appearance: none;
    -moz-appearance: none;
  }

  /* seta customizada no select */
  .styled-select {
    background-image: url("data:image/svg+xml;charset=US-ASCII,%3Csvg%20width%3D%2210%22%20height%3D%227%22%20xmlns%3D%22http://www.w3.org/2000/svg%22%3E%3Cpath%20d%3D%22M0%200l5%207%205-7z%22%20fill%3D%22%23ffffff%22/%3E%3C/svg%3E");
    background-repeat: no-repeat;
    background-position: right 8px center;
    background-size: 12px;
  }

  .styled-select:hover {
    border-color: #888;
  }

  .styled-select:focus {
    outline: none;
    border-color: #00bfff;
  }



</style>
<body>
    <header>
         <div class="particles" id="particles"></div>

    <div class="container-fluid">
        <div class="gaming-container">
            <!-- Gaming Header -->
            <div class="gaming-header">
                <h1><i class="bi bi-controller me-3"></i>GAMING BOLÃO</h1>
                <p><i class="bi bi-trophy-fill me-2"></i>Sistema Profissional de Registro de Jogadas</p>
            </div>

    </header>

    <div class="container">
        <?php if ($mensagem): ?>
            <div class="alert alert-<?php echo $tipo_mensagem; ?>">
                <?php echo $mensagem; ?>
            </div>
        <?php endif; ?>

        <div class="navigation">
            <a href="resultados_user.php" class="btn btn-primary">Ver Resultados</a>
             <a href="../dashboard.php" class="btn btn-primary">Dashboard</a>
        </div>

        <div class="form-container">
            <form method="POST" onsubmit="return confirmarEnvio()">
                <div class="form-group">
                    <label for="nome_jogador">Nome do Jogador:</label>
                    <input type="text" id="nome_jogador" name="nome_jogador" value="<?php echo htmlspecialchars($user_name); ?>" readonly required>
                </div>

                <div class="form-group">
                    <label for="local_jogo">Local:</label>
                    <input type="text" id="local_jogo" name="local_jogo" required>
                </div>

                <div class="form-group">
                    <label for="numero_jogo">Número do Jogo (1-10):</label>
                    <select id="numero_jogo" name="numero_jogo" required>
                        <option value="">Selecione...</option>
                        <?php for ($i = 1; $i <= 10; $i++): ?>
                            <option value="<?php echo $i; ?>">Jogo <?php echo $i; ?></option>
                        <?php endfor; ?>
                    </select>
                </div>

                <!-- Cancha 1 -->
                <div class="cancha-section">
                    <div class="cancha-title">CANCHA 1</div>
                    <div class="jogadas-row">
                        <div>
                            <label>Exp</label>
                            <input type="hidden" id="exp_cancha1" name="exp_cancha1" class="exp-input" readonly>
                        </div>
                        <div>
                            <label>Jog 1</label>
                            <!-- <input type="number" id="cancha1_jog1" name="cancha1_jog1" min="0" max="9" value="0" class="jogada-input" required> -->

                        <select id="cancha1_jog1" name="cancha1_jog1" class="jogada-input styled-select" required>
                        <option value="0">0</option>
                        <option value="1">1</option>
                        <option value="2">2</option>
                        <option value="3">3</option>
                        <option value="4">4</option>
                        <option value="5">5</option>
                        <option value="6">6</option>
                        <option value="7">7</option>
                        <option value="8">8</option>
                        <option value="9">9</option>
                        </select>

                        </div>
                        <div>
                            <label>Jog 2</label>
                            <!-- <input type="number" id="cancha1_jog2" name="cancha1_jog2" min="0" max="9" value="0" class="jogada-input" required> -->

                            <select id="cancha1_jog2" name="cancha1_jog2" class="jogada-input" required>
  <option value="0">0</option>
  <option value="1">1</option>
  <option value="2">2</option>
  <option value="3">3</option>
  <option value="4">4</option>
  <option value="5">5</option>
  <option value="6">6</option>
  <option value="7">7</option>
  <option value="8">8</option>
  <option value="9">9</option>
</select>
                        </div>
                        <div>
                            <label>Jog 3</label>
                            <!-- <input type="number" id="cancha1_jog3" name="cancha1_jog3" min="0" max="9" value="0" class="jogada-input" required> -->
                             <select id="cancha1_jog3" name="cancha1_jog3" class="jogada-input" required>
  <option value="0">0</option>
  <option value="1">1</option>
  <option value="2">2</option>
  <option value="3">3</option>
  <option value="4">4</option>
  <option value="5">5</option>
  <option value="6">6</option>
  <option value="7">7</option>
  <option value="8">8</option>
  <option value="9">9</option>
</select>
                        </div>
                        <div>
                            <label>Jog 4</label>
                            <!-- <input type="number" id="cancha1_jog4" name="cancha1_jog4" min="0" max="9" value="0" class="jogada-input" required> -->
                        <select id="cancha1_jog4" name="cancha1_jog4" class="jogada-input" required>
  <option value="0">0</option>
  <option value="1">1</option>
  <option value="2">2</option>
  <option value="3">3</option>
  <option value="4">4</option>
  <option value="5">5</option>
  <option value="6">6</option>
  <option value="7">7</option>
  <option value="8">8</option>
  <option value="9">9</option>
</select>
                        </div>
                        <div>
                            <label>Jog 5</label>
                            <!-- <input type="number" id="cancha1_jog5" name="cancha1_jog5" min="0" max="9" value="0" class="jogada-input" required> -->
                        
                        <select id="cancha1_jog5" name="cancha1_jog5" class="jogada-input" required>
  <option value="0">0</option>
  <option value="1">1</option>
  <option value="2">2</option>
  <option value="3">3</option>
  <option value="4">4</option>
  <option value="5">5</option>
  <option value="6">6</option>
  <option value="7">7</option>
  <option value="8">8</option>
  <option value="9">9</option>
</select>
</div>
                    </div>
                    <div class="form-group">
                        <label>Subtotal Cancha 1:</label>
                        <input type="number" id="subtotal_cancha1" name="subtotal_cancha1" class="subtotal" readonly>
                    </div>
                </div>

                <!-- Cancha 2 -->
                <div class="cancha-section">
                    <div class="cancha-title">CANCHA 2</div>
                    <div class="jogadas-row">
                        <div>
                            <label>Exp</label>
                            <input type="number" id="exp_cancha2" name="exp_cancha2" class="exp-input" readonly>
                        </div>
                        <div>
                            <label>Jog 6</label>
                            <input type="number" id="cancha2_jog1" name="cancha2_jog1" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 7</label>
                            <input type="number" id="cancha2_jog2" name="cancha2_jog2" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 8</label>
                            <input type="number" id="cancha2_jog3" name="cancha2_jog3" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 9</label>
                            <input type="number" id="cancha2_jog4" name="cancha2_jog4" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 10</label>
                            <input type="number" id="cancha2_jog5" name="cancha2_jog5" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Subtotal Cancha 2:</label>
                        <input type="number" id="subtotal_cancha2" name="subtotal_cancha2" class="subtotal" readonly>
                    </div>
                </div>

                <!-- Cancha 3 -->
                <div class="cancha-section">
                    <div class="cancha-title">CANCHA 3</div>
                    <div class="jogadas-row">
                        <div>
                            <label>Exp</label>
                            <input type="number" id="exp_cancha3" name="exp_cancha3" class="exp-input" readonly>
                        </div>
                        <div>
                            <label>Jog 11</label>
                            <input type="number" id="cancha3_jog1" name="cancha3_jog1" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 12</label>
                            <input type="number" id="cancha3_jog2" name="cancha3_jog2" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 13</label>
                            <input type="number" id="cancha3_jog3" name="cancha3_jog3" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 14</label>
                            <input type="number" id="cancha3_jog4" name="cancha3_jog4" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 15</label>
                            <input type="number" id="cancha3_jog5" name="cancha3_jog5" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Subtotal Cancha 3:</label>
                        <input type="number" id="subtotal_cancha3" name="subtotal_cancha3" class="subtotal" readonly>
                    </div>
                </div>

                <!-- Cancha 4 -->
                <div class="cancha-section">
                    <div class="cancha-title">CANCHA 4</div>
                    <div class="jogadas-row">
                        <div>
                            <label>Exp</label>
                            <input type="number" id="exp_cancha4" name="exp_cancha4" class="exp-input" readonly>
                        </div>
                        <div>
                            <label>Jog 16</label>
                            <input type="number" id="cancha4_jog1" name="cancha4_jog1" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 17</label>
                            <input type="number" id="cancha4_jog2" name="cancha4_jog2" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 18</label>
                            <input type="number" id="cancha4_jog3" name="cancha4_jog3" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 19</label>
                            <input type="number" id="cancha4_jog4" name="cancha4_jog4" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                        <div>
                            <label>Jog 20</label>
                            <input type="number" id="cancha4_jog5" name="cancha4_jog5" min="0" max="9" value="0" class="jogada-input" required>
                        </div>
                    </div>
                    <div class="form-group">
                        <label>Subtotal Cancha 4:</label>
                        <input type="number" id="subtotal_cancha4" name="subtotal_cancha4" class="subtotal" readonly>
                    </div>
                </div>

                <!-- Totais -->
                <div class="totals-section">
                    <h3>Totais do Jogo</h3>
                    <div class="totals-grid">
                        <div class="total-item">
                            <div class="total-label">Total Canchas 1+2</div>
                            <input type="number" id="total_canchas12" name="total_canchas12" class="total-value" readonly>
                        </div>
                        <div class="total-item">
                            <div class="total-label">Total Canchas 3+4</div>
                            <input type="number" id="total_canchas34" name="total_canchas34" class="total-value" readonly>
                        </div>
                        <div class="total-item">
                            <div class="total-label">TT (Total Total)</div>
                            <input type="number" id="tt_total" name="tt_total" class="total-value" readonly>
                        </div>
                    </div>
                </div>

                <div class="form-group" style="text-align: center; margin-top: 2rem;">
                    <button type="submit" class="btn btn-success">Salvar Jogo</button>
                </div>
            </form>
        </div>
    </div>

    <script>
    // Função para calcular subtotais e totais automaticamente
    function calcularTotais() {
        // Calcular subtotais de cada cancha
        const subtotal1 = calcularSubtotalCancha('cancha1');
        const subtotal2 = calcularSubtotalCancha('cancha2');
        const subtotal3 = calcularSubtotalCancha('cancha3');
        const subtotal4 = calcularSubtotalCancha('cancha4');

        // Atualizar campos de subtotais
        document.getElementById('subtotal_cancha1').value = subtotal1;
        document.getElementById('subtotal_cancha2').value = subtotal2;
        document.getElementById('subtotal_cancha3').value = subtotal3;
        document.getElementById('subtotal_cancha4').value = subtotal4;

        // Calcular totais
        const totalCanchas12 = subtotal1 + subtotal2;
        const totalCanchas34 = subtotal3 + subtotal4;
        const ttTotal = totalCanchas12 + totalCanchas34;

        // Atualizar campos de totais
        document.getElementById('total_canchas12').value = totalCanchas12;
        document.getElementById('total_canchas34').value = totalCanchas34;
        document.getElementById('tt_total').value = ttTotal;

        // Atualizar campos Exp (se o primeiro jogo da cancha não for 9)
        atualizarCampoExp('cancha1');
        atualizarCampoExp('cancha2');
        atualizarCampoExp('cancha3');
        atualizarCampoExp('cancha4');
    }

    // Função para calcular subtotal de uma cancha específica
    function calcularSubtotalCancha(cancha) {
        let subtotal = 0;
        for (let i = 1; i <= 5; i++) {
            const input = document.getElementById(`${cancha}_jog${i}`);
            if (input) {
                const valor = parseInt(input.value) || 0;
                subtotal += valor;
            }
        }
        return subtotal;
    }

    // Função para atualizar campo Exp
    function atualizarCampoExp(cancha) {
        const primeiroJogo = parseInt(document.getElementById(`${cancha}_jog1`).value) || 0;
        const campoExp = document.getElementById(`exp_${cancha}`);
        campoExp.value = (primeiroJogo !== 9) ? primeiroJogo : '';
    }

    // Adicionar event listeners para todos os campos de jogadas
    document.addEventListener('DOMContentLoaded', function () {
        const jogadaInputs = document.querySelectorAll('.jogada-input');

        jogadaInputs.forEach(function (input) {
            input.addEventListener('input', calcularTotais);
            input.addEventListener('change', calcularTotais);
        });

        // Calcular totais iniciais ao carregar
        calcularTotais();
    });

    // Reforço: calcular também após todos os elementos carregarem (opcional)
    window.onload = calcularTotais;

    // Confirmação antes de salvar
    function confirmarEnvio() {
        return confirm('Tem certeza que deseja salvar este jogo?');
    }
</script>

</body>
</html>