"""
URL configuration for app project.
"""
from django.contrib import admin
from django.urls import path, include
from django.conf import settings
from django.conf.urls.static import static
from django.contrib.auth import views as auth_views
from django.shortcuts import redirect

def redirect_to_dashboard(request):
    if request.user.is_authenticated:
        return redirect('controler:dashboard')
    return redirect('login')

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', redirect_to_dashboard, name='home'),
    
    # Autenticação
    path('login/', auth_views.LoginView.as_view(template_name='registration/login.html'), name='login'),
    path('logout/', auth_views.LogoutView.as_view(), name='logout'),
    
    # Apps
    path('produtos/', include('produtos.urls')),
    path('grupos/', include('grupos.urls')),
    path('comandas/', include('comandas.urls')),
    path('estoque/', include('estoque.urls')),
    path('controle/', include('controler.urls')),
]

# Servir arquivos de media em desenvolvimento
if settings.DEBUG:
    urlpatterns += static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
