from django.urls import path
from . import views

app_name = 'comandas'

urlpatterns = [
    path('', views.ComandaListView.as_view(), name='list'),
    path('create/', views.ComandaCreateView.as_view(), name='create'),
    path('<int:pk>/', views.ComandaDetailView.as_view(), name='detail'),
    path('<int:pk>/update/', views.ComandaUpdateView.as_view(), name='update'),
    path('<int:pk>/fechar/', views.fechar_comanda, name='fechar'),
    path('<int:pk>/add-item/', views.ComandaItemCreateView.as_view(), name='add_item'),
    path('item/<int:pk>/delete/', views.ComandaItemDeleteView.as_view(), name='delete_item'),
    path('arquivos/', views.ArquivosComandaListView.as_view(), name='arquivos'),
    path('download/<str:filename>/', views.download_arquivo, name='download'),
]
