from django.db import models
from django.contrib.auth.models import User


class Mesa(models.Model):
    numero = models.IntegerField(unique=True)
    descricao = models.CharField(max_length=200, blank=True, null=True)
    capacidade = models.IntegerField(default=4)
    ativa = models.BooleanField(default=True)
    criado_em = models.DateTimeField(auto_now_add=True)
    atualizado_em = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = "Mesa"
        verbose_name_plural = "Mesas"
        ordering = ['numero']

    def __str__(self):
        return f"Mesa {self.numero}"


class RegistroDiario(models.Model):
    data = models.DateField(unique=True)
    arquivado = models.BooleanField(default=False)
    total_vendas = models.DecimalField(max_digits=10, decimal_places=2, default=0)
    total_comandas = models.IntegerField(default=0)
    observacoes = models.TextField(blank=True, null=True)
    criado_em = models.DateTimeField(auto_now_add=True)
    atualizado_em = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = "Registro Diário"
        verbose_name_plural = "Registros Diários"
        ordering = ['-data']

    def __str__(self):
        return f"Registro {self.data.strftime('%d/%m/%Y')}"
