from django.urls import path
from . import views

app_name = 'controler'

urlpatterns = [
    path('', views.DashboardView.as_view(), name='dashboard'),
    path('mesas/', views.MesaListView.as_view(), name='mesas'),
    path('mesas/create/', views.MesaCreateView.as_view(), name='mesa_create'),
    path('mesas/<int:pk>/update/', views.MesaUpdateView.as_view(), name='mesa_update'),
    path('mesas/<int:pk>/delete/', views.MesaDeleteView.as_view(), name='mesa_delete'),
    path('registro-diario/', views.RegistroDiarioView.as_view(), name='registro_diario'),
    path('registro-diario/arquivar/', views.arquivar_dia, name='arquivar_dia'),
]
