from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import MovimentacaoEstoque


@receiver(post_save, sender=MovimentacaoEstoque)
def atualizar_estoque_produto(sender, instance, created, **kwargs):
    """
    Signal para atualizar estoque do produto após movimentação manual
    """
    if created and instance.tipo in ['entrada', 'ajuste']:
        produto = instance.produto
        
        if instance.tipo == 'entrada':
            produto.estoque_atual += instance.quantidade
        elif instance.tipo == 'ajuste':
            produto.estoque_atual = instance.quantidade_atual
            
        produto.save()
