from django.contrib import admin
from .models import GrupoProduto


@admin.register(GrupoProduto)
class GrupoProdutoAdmin(admin.ModelAdmin):
    list_display = ['nome', 'ativo', 'criado_em']
    list_filter = ['ativo', 'criado_em']
    search_fields = ['nome']
    readonly_fields = ['criado_em', 'atualizado_em']
