from django.shortcuts import render
from django.views.generic import ListView, DetailView, CreateView, UpdateView, DeleteView
from django.contrib.auth.mixins import LoginRequiredMixin
from django.urls import reverse_lazy
from .models import GrupoProduto


class GrupoProdutoListView(LoginRequiredMixin, ListView):
    model = GrupoProduto
    template_name = 'grupos/list.html'
    context_object_name = 'grupos'

    def get_queryset(self):
        return GrupoProduto.objects.prefetch_related('produtos').order_by('nome')


class GrupoProdutoDetailView(LoginRequiredMixin, DetailView):
    model = GrupoProduto
    template_name = 'grupos/detail.html'
    context_object_name = 'grupo'


class GrupoProdutoCreateView(LoginRequiredMixin, CreateView):
    model = GrupoProduto
    template_name = 'grupos/form.html'
    fields = ['nome', 'descricao']
    success_url = reverse_lazy('grupos:list')


class GrupoProdutoUpdateView(LoginRequiredMixin, UpdateView):
    model = GrupoProduto
    template_name = 'grupos/form.html'
    fields = ['nome', 'descricao', 'ativo']
    success_url = reverse_lazy('grupos:list')


class GrupoProdutoDeleteView(LoginRequiredMixin, DeleteView):
    model = GrupoProduto
    template_name = 'grupos/confirm_delete.html'
    success_url = reverse_lazy('grupos:list')
