from django.contrib import admin
from .models import Produto


@admin.register(Produto)
class ProdutoAdmin(admin.ModelAdmin):
    list_display = ['nome', 'preco', 'grupo', 'estoque_atual', 'estoque_baixo', 'ativo']
    list_filter = ['grupo', 'ativo', 'criado_em']
    search_fields = ['nome', 'descricao']
    readonly_fields = ['criado_em', 'atualizado_em']
    list_editable = ['preco', 'estoque_atual']
