from django.db import models
from grupos.models import GrupoProduto


class Produto(models.Model):
    nome = models.CharField(max_length=200)
    descricao = models.TextField(blank=True, null=True)
    preco = models.DecimalField(max_digits=10, decimal_places=2)
    grupo = models.ForeignKey(GrupoProduto, on_delete=models.CASCADE, related_name='produtos')
    estoque_atual = models.IntegerField(default=0)
    estoque_minimo = models.IntegerField(default=0)
    thumbnail = models.ImageField(upload_to='produtos/', blank=True, null=True)
    ativo = models.BooleanField(default=True)
    criado_em = models.DateTimeField(auto_now_add=True)
    atualizado_em = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = "Produto"
        verbose_name_plural = "Produtos"
        ordering = ['nome']

    def __str__(self):
        return f"{self.nome} - R$ {self.preco}"

    @property
    def estoque_baixo(self):
        return self.estoque_atual <= self.estoque_minimo

    def reduzir_estoque(self, quantidade):
        if self.estoque_atual >= quantidade:
            self.estoque_atual -= quantidade
            self.save()
            return True
        return False
