from django.shortcuts import render
from django.views.generic import ListView, DetailView, CreateView, UpdateView, DeleteView
from django.contrib.auth.mixins import LoginRequiredMixin
from django.urls import reverse_lazy
from .models import Produto


class ProdutoListView(LoginRequiredMixin, ListView):
    model = Produto
    template_name = 'produtos/list.html'
    context_object_name = 'produtos'
    paginate_by = 20

    def get_queryset(self):
        return Produto.objects.filter(ativo=True).select_related('grupo')


class ProdutoDetailView(LoginRequiredMixin, DetailView):
    model = Produto
    template_name = 'produtos/detail.html'
    context_object_name = 'produto'


class ProdutoCreateView(LoginRequiredMixin, CreateView):
    model = Produto
    template_name = 'produtos/form.html'
    fields = ['nome', 'descricao', 'preco', 'grupo', 'estoque_atual', 'estoque_minimo', 'thumbnail']
    success_url = reverse_lazy('produtos:list')


class ProdutoUpdateView(LoginRequiredMixin, UpdateView):
    model = Produto
    template_name = 'produtos/form.html'
    fields = ['nome', 'descricao', 'preco', 'grupo', 'estoque_atual', 'estoque_minimo', 'thumbnail']
    success_url = reverse_lazy('produtos:list')


class ProdutoDeleteView(LoginRequiredMixin, DeleteView):
    model = Produto
    template_name = 'produtos/confirm_delete.html'
    success_url = reverse_lazy('produtos:list')
