# Sistema de Contatos Intimus RS

## 📋 Descrição

Sistema completo de formulário de contato com dashboard administrativo para gerenciamento de leads. Desenvolvido seguindo os padrões visuais do projeto Intimus RS.

## ✨ Funcionalidades

- **Formulário de Contato**: Layout harmonizado com o projeto, campos: Nome, Telefone e Endereço (sem CPF)
- **Processamento de Dados**: Validação e sanitização de dados com PHP
- **Banco de Dados MySQL**: Armazenamento seguro com informações de origem e IP
- **Dashboard Administrativo**: Interface moderna para visualização de contatos
- **Sistema de Login**: Autenticação segura para acesso ao dashboard
- **Estatísticas**: Visualização de contatos por período (hoje, semana, mês, total)
- **Busca e Filtros**: Pesquisa por nome, telefone ou endereço
- **Paginação**: Listagem organizada com 20 registros por página

## 🗄️ Estrutura do Banco de Dados

### Tabela: contatos
- `id` - INT AUTO_INCREMENT PRIMARY KEY
- `nome` - VARCHAR(255) NOT NULL
- `telefone` - VARCHAR(50) NOT NULL
- `endereco` - VARCHAR(500) NOT NULL
- `origem_nav` - VARCHAR(500) - User Agent do navegador
- `data_created` - DATETIME - Data de criação
- `data_updated` - DATETIME - Data de atualização
- `ip` - VARCHAR(45) - IP do usuário

### Tabela: usuarios_admin
- `id` - INT AUTO_INCREMENT PRIMARY KEY
- `username` - VARCHAR(100) UNIQUE
- `password_hash` - VARCHAR(255)
- `nome` - VARCHAR(255)
- `data_created` - DATETIME
- `ultimo_acesso` - DATETIME

## 🚀 Instalação

### 1. Configurar o Banco de Dados

Execute o arquivo `database.sql` no seu MySQL:

```bash
mysql -u root -p < database.sql
```

Ou importe manualmente através do phpMyAdmin.

### 2. Configurar Credenciais do Banco

Edite o arquivo `config.php` e ajuste as credenciais:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'intimusrs_contatos');
define('DB_USER', 'seu_usuario');
define('DB_PASS', 'sua_senha');
```

### 3. Upload dos Arquivos

Faça upload de todos os arquivos para o servidor web (Apache/Nginx com PHP).

### 4. Configurar Permissões

Certifique-se de que o PHP tem permissão de escrita nos diretórios necessários.

## 🔐 Acesso ao Dashboard

### URL de Acesso
```
http://seudominio.com/admin/login.php
```

### Credenciais Padrão
- **Usuário**: admin
- **Senha**: admin123

⚠️ **IMPORTANTE**: Altere a senha padrão imediatamente após o primeiro acesso!

### Alterar Senha do Admin

Execute no MySQL:

```sql
UPDATE usuarios_admin 
SET password_hash = '$2y$10$NOVO_HASH_AQUI' 
WHERE username = 'admin';
```

Para gerar um novo hash de senha, use:

```php
<?php
echo password_hash('sua_nova_senha', PASSWORD_DEFAULT);
?>
```

## 📁 Estrutura de Arquivos

```
intimusrs_contato/
├── admin/
│   ├── dashboard.php          # Dashboard administrativo
│   ├── login.php              # Página de login
│   ├── processar_login.php    # Processamento de login
│   └── logout.php             # Logout
├── assets/                    # Recursos (imagens, etc)
├── static/                    # Arquivos estáticos
├── config.php                 # Configurações do banco
├── contato.php                # Formulário de contato
├── processa_contato.php       # Processamento do formulário
├── database.sql               # Script de criação do banco
├── header.php                 # Cabeçalho do site
├── footer.php                 # Rodapé do site
├── index.php                  # Página inicial
├── style.css                  # Estilos CSS
└── script.js                  # Scripts JavaScript
```

## 🎨 Paleta de Cores

- **Primary**: #A91D5A (Magenta Escuro)
- **Secondary**: #C72C57 (Magenta Mais Escuro)
- **Tertiary**: #E6C3B6 (Rosa Claro/Bege)
- **Dark BG**: #464646 (Cinza Escuro)
- **Light Text**: #FFFFFF (Branco)
- **Dark Text**: #333333 (Quase Preto)

## 🔧 Requisitos do Servidor

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Extensões PHP: PDO, PDO_MySQL
- Apache/Nginx com mod_rewrite habilitado

## 📝 Notas Importantes

1. O campo **CPF foi removido** do formulário conforme solicitado
2. O layout do formulário foi **harmonizado** com o restante do projeto
3. Todos os dados são **validados e sanitizados** antes de serem salvos
4. O sistema captura automaticamente **IP e User Agent** dos visitantes
5. A sessão do admin expira após **30 minutos** de inatividade

## 🐛 Solução de Problemas

### Erro de Conexão com o Banco
- Verifique as credenciais em `config.php`
- Certifique-se de que o banco de dados foi criado
- Verifique se o MySQL está rodando

### Erro ao Enviar Formulário
- Verifique as permissões de escrita
- Confira os logs de erro do PHP
- Certifique-se de que a tabela `contatos` existe

### Não Consegue Fazer Login
- Verifique se a tabela `usuarios_admin` foi criada
- Confirme que o usuário padrão foi inserido
- Limpe os cookies do navegador

## 📞 Suporte

Para dúvidas ou problemas, consulte os logs de erro do PHP ou entre em contato com o desenvolvedor.

---

**Desenvolvido para Intimus RS** 🌸

