<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastro de Usuário - Dashboard Intimus RS</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --color-primary: #A91D5A;
            --color-secondary: #C72C57;
            --color-tertiary: #E6C3B6;
            --color-dark-bg: #464646;
            --color-light-text: #FFFFFF;
            --color-dark-text: #333333;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat', sans-serif;
            background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-secondary) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .cadastro-container {
            background-color: var(--color-light-text);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 50px 40px;
            max-width: 500px;
            width: 100%;
        }

        .cadastro-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .cadastro-header h1 {
            color: var(--color-primary);
            font-size: 2.2em;
            margin-bottom: 10px;
            font-weight: 800;
        }

        .cadastro-header p {
            color: #666;
            font-size: 0.95em;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            color: var(--color-dark-text);
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 0.95em;
        }

        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1em;
            font-family: 'Montserrat', sans-serif;
            transition: all 0.3s ease;
            background-color: #fafafa;
        }

        .form-group input:focus {
            outline: none;
            border-color: var(--color-primary);
            background-color: var(--color-light-text);
            box-shadow: 0 0 0 3px rgba(169, 29, 90, 0.1);
        }

        .form-group small {
            display: block;
            color: #999;
            font-size: 0.85em;
            margin-top: 5px;
        }

        .btn-cadastro {
            width: 100%;
            padding: 15px;
            background-color: var(--color-primary);
            color: var(--color-light-text);
            border: none;
            border-radius: 10px;
            font-size: 1em;
            font-weight: 700;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-cadastro:hover {
            background-color: var(--color-secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 0.9em;
            text-align: center;
        }

        .alert-error {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .alert-success {
            background-color: #d4edda;
            border: 1px solid #c3e6cb;
            color: #155724;
        }

        .back-link {
            text-align: center;
            margin-top: 25px;
        }

        .back-link a {
            color: var(--color-primary);
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .back-link a:hover {
            color: var(--color-secondary);
        }

        .password-strength {
            margin-top: 10px;
            height: 5px;
            background-color: #e0e0e0;
            border-radius: 3px;
            overflow: hidden;
        }

        .password-strength-bar {
            height: 100%;
            width: 0%;
            transition: all 0.3s ease;
        }

        .strength-weak {
            width: 33%;
            background-color: #dc3545;
        }

        .strength-medium {
            width: 66%;
            background-color: #ffc107;
        }

        .strength-strong {
            width: 100%;
            background-color: #28a745;
        }

        @media (max-width: 500px) {
            .cadastro-container {
                padding: 40px 30px;
            }

            .cadastro-header h1 {
                font-size: 1.8em;
            }
        }
    </style>
</head>
<body>
    <div class="cadastro-container">
        <div class="cadastro-header">
            <h1>Novo Usuário</h1>
            <p>Cadastro de Administrador</p>
        </div>

        <?php
        session_start();
        if (isset($_GET['erro'])) {
            echo '<div class="alert alert-error">';
            switch($_GET['erro']) {
                case 'campos':
                    echo 'Por favor, preencha todos os campos.';
                    break;
                case 'senha':
                    echo 'As senhas não coincidem.';
                    break;
                case 'senha_fraca':
                    echo 'A senha deve ter no mínimo 6 caracteres.';
                    break;
                case 'usuario_existe':
                    echo 'Este nome de usuário já está em uso.';
                    break;
                case 'sistema':
                    echo 'Erro ao criar usuário. Tente novamente.';
                    break;
                default:
                    echo 'Erro desconhecido.';
            }
            echo '</div>';
        }

        if (isset($_GET['sucesso']) && $_GET['sucesso'] == '1') {
            echo '<div class="alert alert-success">';
            echo 'Usuário cadastrado com sucesso! Você já pode fazer login.';
            echo '</div>';
        }
        ?>

        <form method="post" action="processar_cadastro.php" id="formCadastro">
            <div class="form-group">
                <label for="nome">Nome Completo</label>
                <input type="text" id="nome" name="nome" required>
            </div>

            <div class="form-group">
                <label for="username">Nome de Usuário</label>
                <input type="text" id="username" name="username" required>
                <small>Use apenas letras, números e underscore (_)</small>
            </div>

            <div class="form-group">
                <label for="password">Senha</label>
                <input type="password" id="password" name="password" required>
                <small>Mínimo de 6 caracteres</small>
                <div class="password-strength">
                    <div class="password-strength-bar" id="strengthBar"></div>
                </div>
            </div>

            <div class="form-group">
                <label for="password_confirm">Confirmar Senha</label>
                <input type="password" id="password_confirm" name="password_confirm" required>
            </div>

            <button type="submit" class="btn-cadastro">Cadastrar</button>
        </form>

        <div class="back-link">
            <a href="login.php">← Voltar para o login</a>
        </div>
    </div>

    <script>
        // Verificador de força de senha
        const passwordInput = document.getElementById('password');
        const strengthBar = document.getElementById('strengthBar');

        passwordInput.addEventListener('input', function() {
            const password = this.value;
            let strength = 0;

            if (password.length >= 6) strength++;
            if (password.length >= 10) strength++;
            if (/[a-z]/.test(password) && /[A-Z]/.test(password)) strength++;
            if (/\d/.test(password)) strength++;
            if (/[^a-zA-Z0-9]/.test(password)) strength++;

            strengthBar.className = 'password-strength-bar';
            
            if (strength <= 2) {
                strengthBar.classList.add('strength-weak');
            } else if (strength <= 4) {
                strengthBar.classList.add('strength-medium');
            } else {
                strengthBar.classList.add('strength-strong');
            }
        });

        // Validação do formulário
        document.getElementById('formCadastro').addEventListener('submit', function(e) {
            const password = document.getElementById('password').value;
            const passwordConfirm = document.getElementById('password_confirm').value;

            if (password !== passwordConfirm) {
                e.preventDefault();
                alert('As senhas não coincidem!');
                return false;
            }

            if (password.length < 6) {
                e.preventDefault();
                alert('A senha deve ter no mínimo 6 caracteres!');
                return false;
            }
        });
    </script>
</body>
</html>

