<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Dashboard Intimus RS</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        :root {
            --color-primary: #A91D5A;
            --color-secondary: #C72C57;
            --color-tertiary: #E6C3B6;
            --color-dark-bg: #464646;
            --color-light-text: #FFFFFF;
            --color-dark-text: #333333;
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Montserrat', sans-serif;
            background: linear-gradient(135deg, var(--color-primary) 0%, var(--color-secondary) 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }

        .login-container {
            background-color: var(--color-light-text);
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0, 0, 0, 0.3);
            padding: 50px 40px;
            max-width: 450px;
            width: 100%;
        }

        .login-header {
            text-align: center;
            margin-bottom: 40px;
        }

        .login-header h1 {
            color: var(--color-primary);
            font-size: 2.2em;
            margin-bottom: 10px;
            font-weight: 800;
        }

        .login-header p {
            color: #666;
            font-size: 0.95em;
        }

        .form-group {
            margin-bottom: 25px;
        }

        .form-group label {
            display: block;
            color: var(--color-dark-text);
            font-weight: 600;
            margin-bottom: 8px;
            font-size: 0.95em;
        }

        .form-group input {
            width: 100%;
            padding: 15px;
            border: 2px solid #e0e0e0;
            border-radius: 10px;
            font-size: 1em;
            font-family: 'Montserrat', sans-serif;
            transition: all 0.3s ease;
            background-color: #fafafa;
        }

        .form-group input:focus {
            outline: none;
            border-color: var(--color-primary);
            background-color: var(--color-light-text);
            box-shadow: 0 0 0 3px rgba(169, 29, 90, 0.1);
        }

        .btn-login {
            width: 100%;
            padding: 15px;
            background-color: var(--color-primary);
            color: var(--color-light-text);
            border: none;
            border-radius: 10px;
            font-size: 1em;
            font-weight: 700;
            text-transform: uppercase;
            cursor: pointer;
            transition: all 0.3s ease;
            margin-top: 10px;
        }

        .btn-login:hover {
            background-color: var(--color-secondary);
            transform: translateY(-2px);
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.2);
        }

        .alert {
            padding: 15px 20px;
            border-radius: 10px;
            margin-bottom: 25px;
            font-size: 0.9em;
            text-align: center;
        }

        .alert-error {
            background-color: #f8d7da;
            border: 1px solid #f5c6cb;
            color: #721c24;
        }

        .back-link {
            text-align: center;
            margin-top: 25px;
        }

        .back-link a {
            color: var(--color-primary);
            text-decoration: none;
            font-weight: 600;
            transition: color 0.3s ease;
        }

        .back-link a:hover {
            color: var(--color-secondary);
        }

        .divider {
            text-align: center;
            margin: 25px 0;
            position: relative;
        }

        .divider::before {
            content: '';
            position: absolute;
            top: 50%;
            left: 0;
            right: 0;
            height: 1px;
            background-color: #e0e0e0;
        }

        .divider span {
            background-color: var(--color-light-text);
            padding: 0 15px;
            color: #999;
            font-size: 0.9em;
            position: relative;
            z-index: 1;
        }

        .cadastro-link {
            text-align: center;
            margin-top: 20px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 10px;
        }

        .cadastro-link p {
            color: #666;
            font-size: 0.9em;
            margin-bottom: 10px;
        }

        .cadastro-link a {
            color: var(--color-primary);
            text-decoration: none;
            font-weight: 700;
            transition: color 0.3s ease;
        }

        .cadastro-link a:hover {
            color: var(--color-secondary);
        }

        @media (max-width: 500px) {
            .login-container {
                padding: 40px 30px;
            }

            .login-header h1 {
                font-size: 1.8em;
            }
        }
    </style>
</head>
<body>
    <div class="login-container">
        <div class="login-header">
            <h1>Dashboard</h1>
            <p>Intimus RS - Área Administrativa</p>
        </div>

        <?php
        session_start();
        if (isset($_GET['erro'])) {
            echo '<div class="alert alert-error">';
            switch($_GET['erro']) {
                case 'credenciais':
                    echo 'Usuário ou senha incorretos.';
                    break;
                case 'sessao':
                    echo 'Sua sessão expirou. Faça login novamente.';
                    break;
                default:
                    echo 'Erro ao fazer login. Tente novamente.';
            }
            echo '</div>';
        }
        ?>

        <form method="post" action="processar_login.php">
            <div class="form-group">
                <label for="username">Usuário</label>
                <input type="text" id="username" name="username" required autofocus>
            </div>

            <div class="form-group">
                <label for="password">Senha</label>
                <input type="password" id="password" name="password" required>
            </div>

            <button type="submit" class="btn-login">Entrar</button>
        </form>

        <div class="divider">
            <span>ou</span>
        </div>

        <div class="cadastro-link">
            <p>Ainda não tem uma conta?</p>
            <a href="cadastro.php">Cadastrar novo usuário →</a>
        </div>

        <div class="back-link">
            <a href="../index.php">← Voltar ao site</a>
        </div>
    </div>
</body>
</html>

