<?php
/**
 * Processamento de Cadastro de Usuário Administrativo
 * Intimus RS - Dashboard Administrativo
 */

require_once '../config.php';

// Verifica se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: cadastro.php');
    exit;
}

// Captura os dados do formulário
$nome = isset($_POST['nome']) ? trim($_POST['nome']) : '';
$username = isset($_POST['username']) ? trim($_POST['username']) : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';
$password_confirm = isset($_POST['password_confirm']) ? trim($_POST['password_confirm']) : '';

// Validações básicas
if (empty($nome) || empty($username) || empty($password) || empty($password_confirm)) {
    header('Location: cadastro.php?erro=campos');
    exit;
}

// Valida se as senhas coincidem
if ($password !== $password_confirm) {
    header('Location: cadastro.php?erro=senha');
    exit;
}

// Valida tamanho mínimo da senha
if (strlen($password) < 6) {
    header('Location: cadastro.php?erro=senha_fraca');
    exit;
}

// Sanitiza o nome de usuário (apenas letras, números e underscore)
$username = preg_replace('/[^a-zA-Z0-9_]/', '', $username);

if (empty($username)) {
    header('Location: cadastro.php?erro=usuario_invalido');
    exit;
}

try {
    // Conecta ao banco de dados
    $pdo = getDBConnection();
    
    // Verifica se o nome de usuário já existe
    $sqlCheck = "SELECT id FROM usuarios_admin WHERE username = :username LIMIT 1";
    $stmtCheck = $pdo->prepare($sqlCheck);
    $stmtCheck->bindParam(':username', $username, PDO::PARAM_STR);
    $stmtCheck->execute();
    
    if ($stmtCheck->rowCount() > 0) {
        header('Location: cadastro.php?erro=usuario_existe');
        exit;
    }
    
    // Gera o hash da senha
    $password_hash = password_hash($password, PASSWORD_DEFAULT);
    
    // Insere o novo usuário
    $sql = "INSERT INTO usuarios_admin (username, password_hash, nome) 
            VALUES (:username, :password_hash, :nome)";
    
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->bindParam(':password_hash', $password_hash, PDO::PARAM_STR);
    $stmt->bindParam(':nome', $nome, PDO::PARAM_STR);
    
    if ($stmt->execute()) {
        // Sucesso - redireciona para login com mensagem de sucesso
        header('Location: cadastro.php?sucesso=1');
        exit;
    } else {
        // Erro na execução
        error_log("Erro ao inserir usuário no banco de dados");
        header('Location: cadastro.php?erro=sistema');
        exit;
    }
    
} catch (PDOException $e) {
    // Erro de banco de dados
    error_log("Erro PDO no cadastro: " . $e->getMessage());
    header('Location: cadastro.php?erro=sistema');
    exit;
} catch (Exception $e) {
    // Erro genérico
    error_log("Erro no cadastro: " . $e->getMessage());
    header('Location: cadastro.php?erro=sistema');
    exit;
}
?>

