<?php
/**
 * Processamento de Login
 * Intimus RS - Dashboard Administrativo
 */

require_once '../config.php';

// Verifica se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: login.php');
    exit;
}

// Captura os dados do formulário
$username = isset($_POST['username']) ? trim($_POST['username']) : '';
$password = isset($_POST['password']) ? trim($_POST['password']) : '';

// Validações básicas
if (empty($username) || empty($password)) {
    header('Location: login.php?erro=credenciais');
    exit;
}

try {
    // Conecta ao banco de dados
    $pdo = getDBConnection();
    
    // Busca o usuário no banco
    $sql = "SELECT id, username, password_hash, nome FROM usuarios_admin WHERE username = :username LIMIT 1";
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':username', $username, PDO::PARAM_STR);
    $stmt->execute();
    
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Verifica se o usuário existe e se a senha está correta
    if ($usuario && password_verify($password, $usuario['password_hash'])) {
        // Login bem-sucedido
        $_SESSION['admin_logado'] = true;
        $_SESSION['admin_id'] = $usuario['id'];
        $_SESSION['admin_username'] = $usuario['username'];
        $_SESSION['admin_nome'] = $usuario['nome'];
        $_SESSION['admin_login_time'] = time();
        
        // Atualiza o último acesso
        $updateSql = "UPDATE usuarios_admin SET ultimo_acesso = NOW() WHERE id = :id";
        $updateStmt = $pdo->prepare($updateSql);
        $updateStmt->bindParam(':id', $usuario['id'], PDO::PARAM_INT);
        $updateStmt->execute();
        
        // Redireciona para o dashboard
        header('Location: dashboard.php');
        exit;
    } else {
        // Credenciais inválidas
        header('Location: login.php?erro=credenciais');
        exit;
    }
    
} catch (PDOException $e) {
    error_log("Erro PDO no login: " . $e->getMessage());
    header('Location: login.php?erro=sistema');
    exit;
} catch (Exception $e) {
    error_log("Erro no login: " . $e->getMessage());
    header('Location: login.php?erro=sistema');
    exit;
}
?>

