<?php
/**
 * Configuração do Banco de Dados
 * Intimus RS - Sistema de Contatos
 */

// Configurações do banco de dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'intimusrs_contatos');
define('DB_USER', 'root');
define('DB_PASS', '');
define('DB_CHARSET', 'utf8mb4');

// Função para conectar ao banco de dados
function getDBConnection() {
    try {
        // Primeiro tenta conectar sem especificar o banco para verificar se existe
        $dsn = "mysql:host=" . DB_HOST . ";charset=" . DB_CHARSET;
        $options = [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false,
        ];
        
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        
        // Verifica se o banco de dados existe
        $stmt = $pdo->query("SHOW DATABASES LIKE '" . DB_NAME . "'");
        if ($stmt->rowCount() == 0) {
            // Cria o banco de dados se não existir
            $pdo->exec("CREATE DATABASE IF NOT EXISTS " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        }
        
        // Agora conecta ao banco de dados específico
        $dsn = "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=" . DB_CHARSET;
        $pdo = new PDO($dsn, DB_USER, DB_PASS, $options);
        
        // Verifica se as tabelas existem
        $stmt = $pdo->query("SHOW TABLES LIKE 'contatos'");
        if ($stmt->rowCount() == 0) {
            // Cria a tabela contatos
            $pdo->exec("CREATE TABLE IF NOT EXISTS contatos (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome VARCHAR(255) NOT NULL,
                telefone VARCHAR(50) NOT NULL,
                endereco VARCHAR(500) NOT NULL,
                origem_nav VARCHAR(500) DEFAULT NULL,
                data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
                data_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
                ip VARCHAR(45) DEFAULT NULL,
                INDEX idx_data_created (data_created),
                INDEX idx_nome (nome)
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        }
        
        // Verifica se a tabela de usuários admin existe
        $stmt = $pdo->query("SHOW TABLES LIKE 'usuarios_admin'");
        if ($stmt->rowCount() == 0) {
            // Cria a tabela usuarios_admin
            $pdo->exec("CREATE TABLE IF NOT EXISTS usuarios_admin (
                id INT AUTO_INCREMENT PRIMARY KEY,
                username VARCHAR(100) NOT NULL UNIQUE,
                password_hash VARCHAR(255) NOT NULL,
                nome VARCHAR(255) NOT NULL,
                data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
                ultimo_acesso DATETIME DEFAULT NULL
            ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
            
            // Insere o usuário admin padrão (senha: admin123)
            $pdo->exec("INSERT INTO usuarios_admin (username, password_hash, nome) 
                       VALUES ('admin', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrador')");
        }
        
        return $pdo;
    } catch (PDOException $e) {
        error_log("Erro de conexão com o banco de dados: " . $e->getMessage());
        die("Erro ao conectar com o banco de dados. Detalhes: " . $e->getMessage() . "<br><br>Verifique se o MySQL está rodando e as credenciais em config.php estão corretas.");
    }
}

// Função para obter IP do usuário
function getUserIP() {
    $ip = '';
    
    if (!empty($_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    } elseif (!empty($_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } else {
        $ip = $_SERVER['REMOTE_ADDR'] ?? '';
    }
    
    return filter_var($ip, FILTER_VALIDATE_IP) ? $ip : '0.0.0.0';
}

// Função para obter User Agent
function getUserAgent() {
    return $_SERVER['HTTP_USER_AGENT'] ?? 'Desconhecido';
}

// Iniciar sessão se não estiver iniciada
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}
?>

