<?php
require_once 'header.php';
?>
<div class="hero-section contato-hero">
    <div class="container">
        <div class="hero-content">
            <h1>Fale Conosco</h1>
            <p>Estamos aqui para ajudar! Entre em contato conosco para tornar-se uma
                revendedora Intimus RS ou para esclarecer qualquer dúvida que você tenha.
            </p>
        </div>
    </div>
</div>

<section class="section contato-section">
    <div class="container">
        <div class="contato-wrapper">
            <div class="contato-form-box">
                <h2>Envie sua mensagem</h2>
                <p class="form-subtitle">Preencha o formulário abaixo e entraremos em contato em breve.</p>
                
                <?php if (isset($_GET['sucesso']) && $_GET['sucesso'] == '1'): ?>
                    <div class="alert alert-success">
                        <strong>Sucesso!</strong> Sua mensagem foi enviada com sucesso. Entraremos em contato em breve!
                    </div>
                <?php endif; ?>
                
                <?php if (isset($_GET['erro'])): ?>
                    <div class="alert alert-error">
                        <strong>Erro!</strong> 
                        <?php 
                        switch($_GET['erro']) {
                            case 'campos':
                                echo 'Por favor, preencha todos os campos obrigatórios.';
                                break;
                            case 'telefone':
                                echo 'O telefone informado não é válido.';
                                break;
                            case 'sistema':
                                echo 'Ocorreu um erro ao processar sua mensagem. Tente novamente.';
                                break;
                            default:
                                echo 'Ocorreu um erro desconhecido.';
                        }
                        ?>
                    </div>
                <?php endif; ?>
                
                <form class="contato-form" method="post" action="processa_contato.php">
                    <div class="form-group">
                        <label for="nome">Nome Completo *</label>
                        <input type="text" id="nome" name="nome" placeholder="Digite seu nome completo" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="telefone">Telefone/WhatsApp *</label>
                        <input type="tel" id="telefone" name="telefone" placeholder="(00) 00000-0000" required>
                    </div>
                    
                    <div class="form-group">
                        <label for="endereco">Endereço *</label>
                        <input type="text" id="endereco" name="endereco" placeholder="Rua, número, bairro, cidade - UF" required>
                    </div>
                    
                    <div class="form-actions">
                        <button type="submit" class="btn btn-primary">Enviar Mensagem</button>
                    </div>
                </form>
            </div>
            
            <div class="contato-info-box">
                <h3>Informações de Contato</h3>
                <div class="info-item">
                    <div class="info-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M22 16.92v3a2 2 0 0 1-2.18 2 19.79 19.79 0 0 1-8.63-3.07 19.5 19.5 0 0 1-6-6 19.79 19.79 0 0 1-3.07-8.67A2 2 0 0 1 4.11 2h3a2 2 0 0 1 2 1.72 12.84 12.84 0 0 0 .7 2.81 2 2 0 0 1-.45 2.11L8.09 9.91a16 16 0 0 0 6 6l1.27-1.27a2 2 0 0 1 2.11-.45 12.84 12.84 0 0 0 2.81.7A2 2 0 0 1 22 16.92z"></path>
                        </svg>
                    </div>
                    <div class="info-content">
                        <h4>Telefone/WhatsApp</h4>
                        <p>(51) 98447-6286</p>
                    </div>
                </div>
                
                <div class="info-item">
                    <div class="info-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M4 4h16c1.1 0 2 .9 2 2v12c0 1.1-.9 2-2 2H4c-1.1 0-2-.9-2-2V6c0-1.1.9-2 2-2z"></path>
                            <polyline points="22,6 12,13 2,6"></polyline>
                        </svg>
                    </div>
                    <div class="info-content">
                        <h4>E-mail</h4>
                        <p>contato@intimusrsatacado.com.br</p>
                    </div>
                </div>
                
                <div class="info-item">
                    <div class="info-icon">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <circle cx="12" cy="12" r="10"></circle>
                            <polyline points="12 6 12 12 16 14"></polyline>
                        </svg>
                    </div>
                    <div class="info-content">
                        <h4>Horário de Atendimento</h4>
                        <p>Segunda a Sexta: 9h às 18h</p>
                    </div>
                </div>
                
                <div class="social-contact">
                    <h4>Siga-nos nas redes sociais</h4>
                    <div class="social-links-contact">
                        <a href="#" title="Instagram" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <rect x="2" y="2" width="20" height="20" rx="5" ry="5"></rect>
                                <path d="M16 11.37A4 4 0 1 1 12.63 8 4 4 0 0 1 16 11.37z"></path>
                                <line x1="17.5" y1="6.5" x2="17.51" y2="6.5"></line>
                            </svg>
                        </a>
                        <a href="#" title="WhatsApp" target="_blank">
                            <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <path d="M21 11.5a8.38 8.38 0 0 1-.9 3.8 8.5 8.5 0 0 1-7.6 4.7 8.38 8.38 0 0 1-3.8-.9L3 21l1.9-5.7a8.38 8.38 0 0 1-.9-3.8 8.5 8.5 0 0 1 4.7-7.6 8.38 8.38 0 0 1 3.8-.9h.5a8.48 8.48 0 0 1 8 8v.5z"></path>
                            </svg>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<?php
require_once 'footer.php';
?>

