-- Script de criação do banco de dados e tabelas
-- Intimus RS - Sistema de Contatos

CREATE DATABASE IF NOT EXISTS intimusrs_contatos CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;

USE intimusrs_contatos;

-- Tabela de contatos
CREATE TABLE IF NOT EXISTS contatos (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nome VARCHAR(255) NOT NULL,
    telefone VARCHAR(50) NOT NULL,
    endereco VARCHAR(500) NOT NULL,
    origem_nav VARCHAR(500) DEFAULT NULL,
    data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
    data_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    ip VARCHAR(45) DEFAULT NULL,
    INDEX idx_data_created (data_created),
    INDEX idx_nome (nome)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Tabela de usuários admin
CREATE TABLE IF NOT EXISTS usuarios_admin (
    id INT AUTO_INCREMENT PRIMARY KEY,
    username VARCHAR(100) NOT NULL UNIQUE,
    password_hash VARCHAR(255) NOT NULL,
    nome VARCHAR(255) NOT NULL,
    data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
    ultimo_acesso DATETIME DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Inserir usuário admin padrão (senha: admin123)
INSERT INTO usuarios_admin (username, password_hash, nome) 
VALUES ('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrador')
ON DUPLICATE KEY UPDATE username=username;

