<?php
require_once 'header.php';
?>

<!-- Seção Principal (Hero) -->
<section id="inicio" class="hero-section">
    <div class="container">
        <div class="hero-content">
            <h1>Trabalhe de casa revendendo lingeries, roupas e pijamas por atacado, com qualidade, estilo e lucro real!</h1>
            <p>Você está a um passo de transformar sua renda com um negócio simples, acessível e cheio de possibilidades. Na Intimus RS, você encontra mais do que moda íntima — você encontra <strong>liberdade de escolha e autonomia financeira</strong>, com o suporte certo para começar do zero ou expandir o que já construiu.</p>
            <a href="contato.php" class="btn btn-primary">QUERO SER REVENDEDOR(A)</a>
        </div>
    </div>
</section>

 
<section class="section benefits-section">
    <div class="container">
        <h2>Por que revender com a Intimus RS?</h2>
        <div class="benefits-grid">
            <div class="benefit-item fade-in">
                <div class="benefit-image-wrapper border-blue">
                    <img src="static/image/estoque.avif" alt="Estoque sempre atualizado">
                </div>
                <h3>Estoque sempre atualizado</h3>
            </div>
            <div class="benefit-item fade-in">
                <div class="benefit-image-wrapper border-purple">
                    <img src="static/image/pronta_entrega.avif" alt="Pronta entrega e envio rápido">
                </div>
                <h3>Pronta entrega e envio rápido</h3>
            </div>
            <div class="benefit-item fade-in">
                <div class="benefit-image-wrapper border-orange">
                    <img src="static/image/suporte.avif" alt="Suporte para revendedoras iniciantes">
                </div>
                <h3>Suporte para revendedoras iniciantes</h3>
            </div>
            <div class="benefit-item fade-in">
                <div class="benefit-image-wrapper border-pink">
                    <img src="static/image/comece_com_pouco.avif" alt="Comece com pouco e lucre muito">
                </div>
                <h3>Comece com pouco e lucre muito.</h3>
            </div>
        </div>
        <div class="cta-center">
            <a href="contato.php" class="btn btn-primary">QUERO SER REVENDEDOR(A)</a>
        </div>
    </div>
</section>

<!-- Seção de Depoimentos -->
<section class="section testimonials-section">
    <div class="container">
        <h2>Depoimento de quem já começou</h2>
        <div class="testimonials-grid">
            <div class="testimonial-card fade-in">
                <p>"Comecei com um kit pequeno e em menos de um mês tive retorno. Além do lucro, o melhor foi ver minha confiança crescer!"</p>
                <small>– Juliana, revendedora Intimus RS</small>
                <div class="testimonial-dots">
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                </div>
            </div>
            <div class="testimonial-card fade-in">
                <p>"Eu trabalhava em salão de beleza e sentia que precisava de uma renda a mais. Quando conheci a Intimus RS, vi uma oportunidade real. Hoje revendo para minhas próprias clientes e dobrei meus ganhos!"</p>
                <small>— Renata, Revendedora Intimus RS</small>
                <div class="testimonial-dots">
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                </div>
            </div>
            <div class="testimonial-card fade-in">
                <p>"Sempre tive medo de vender, achava que não era pra mim. Mas com o suporte que recebi, tudo ficou mais fácil. Comecei com um kit pequeno, e hoje faço pedidos todo mês. O que mais amo é ter minha renda e meus horários!"</p>
                <small>— Carla, Revendedora Intimus RS</small>
                <div class="testimonial-dots">
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                    <span class="dot"></span>
                </div>
            </div>
        </div>
        <div class="cta-center">
            <a href="contato.php" class="btn btn-primary">QUERO SER REVENDEDOR(A)</a>
        </div>
    </div>
</section>

<!-- Seção Público-Alvo -->
<section class="section target-section">
    <div class="container">
        <h2>Ideal para você que:</h2>
        <ul class="target-list">
            <li>Quer ter uma renda extra</li>
            <li>Busca liberdade financeira</li>
            <li>Ama o mundo da moda</li>
            <li>Sonha em empreender com segurança, suporte e lucro</li>
        </ul>
        <div class="cta-center">
            <a href="contato.php" btn btn-primary">QUERO SER REVENDEDOR(A)</a>
        </div>
    </div>
</section>

<!-- Seção Início Rápido -->
<section id="revendedor" class="section quick-start-section">
    <div class="container">
        <h2>Comece agora e transforme sua rotina</h2>
        <div class="quick-start-grid">
            <div class="quick-start-item fade-in">
                <div class="quick-start-image-wrapper border-blue">
                    <img src="static/image/kits.avif" alt="Comece com nossos kits de início rápido">
                </div>
                <h3>Comece com nossos kits de início rápido</h3>
            </div>
            <div class="quick-start-item fade-in">
                <div class="quick-start-image-wrapper border-orange">
                    <img src="static/image/revenda.avif" alt="Comece a revender ainda essa semana">
                </div>
                <h3>Comece a revender ainda essa semana</h3>
            </div>
            <div class="quick-start-item fade-in">
                <div class="quick-start-image-wrapper">
                    <img src="static/image/suporte_revendedores_novos.avif" alt="Tenha suporte para suas dúvidas">
                </div>
                <h3>Tenha suporte para suas dúvidas</h3>
            </div>
        </div>
    </div>
</section>

<!-- Seção CTA Final -->
<section id="cadastro" class="section final-cta-section">
    <div class="container">
        <h2>Faça parte da Intimus RS</h2>
        <h3>Liberdade. Beleza. Lucro</h3>
        <p>Clique no botão abaixo para começar agora</p>
        <a href="contato.php" class="btn btn-primary">QUERO SER REVENDEDOR(A)</a>
    </div>
</section>
<!-- Botão Flutuante WhatsApp com Animações e Destaques -->
<script>
  const whatsappNumber = "5599999999999"; // Substitua pelo seu número com DDI
  const mensagemPadrao = "Olá! Gostaria de saber mais informações."; // Mensagem inicial

  // Criação do botão
  const btn = document.createElement("div");
  btn.innerHTML = `
    <a href="https://wa.me/${whatsappNumber}?text=${encodeURIComponent(mensagemPadrao)}" target="_blank" aria-label="WhatsApp">
      <img src="https://upload.wikimedia.org/wikipedia/commons/6/6b/WhatsApp.svg" alt="WhatsApp" style="width:60px;height:60px;">
    </a>
  `;

  // Estilos principais
  btn.style.position = "fixed";
  btn.style.bottom = "20px";
  btn.style.right = "20px";
  btn.style.zIndex = "9999";
  btn.style.cursor = "pointer";
  btn.style.transition = "all 0.3s ease";
  btn.style.borderRadius = "50%";
  btn.style.backgroundColor = "#25D366";
  btn.style.padding = "10px";
  btn.style.boxShadow = "0 2px 8px rgba(0,0,0,0.3)";
  btn.style.display = "flex";
  btn.style.alignItems = "center";
  btn.style.justifyContent = "center";

  // Animação pulsante
  const style = document.createElement("style");
  style.textContent = `
    @keyframes pulsar {
      0% { transform: scale(1); box-shadow: 0 0 0 rgba(37, 211, 102, 0.4); }
      50% { transform: scale(1.08); box-shadow: 0 0 15px rgba(37, 211, 102, 0.6); }
      100% { transform: scale(1); box-shadow: 0 0 0 rgba(37, 211, 102, 0.4); }
    }
  `;
  document.head.appendChild(style);

  btn.style.animation = "pulsar 2.5s ease-in-out infinite";

  // Efeito hover — destaque verde mais intenso
  btn.addEventListener("mouseenter", () => {
    btn.style.backgroundColor = "#1EBE57";
    btn.style.boxShadow = "0 0 20px rgba(30,190,87,0.8)";
    btn.style.transform = "scale(1.1)";
  });

  // Sai do hover
  btn.addEventListener("mouseleave", () => {
    btn.style.backgroundColor = "#25D366";
    btn.style.boxShadow = "0 2px 8px rgba(0,0,0,0.3)";
    btn.style.transform = "scale(1)";
  });

  // Clique — destaque branco momentâneo
  btn.addEventListener("mousedown", () => {
    btn.style.backgroundColor = "#ffffff";
    btn.style.boxShadow = "0 0 20px rgba(255,255,255,0.8)";
  });

  btn.addEventListener("mouseup", () => {
    // Retorna suavemente à cor original após o clique
    setTimeout(() => {
      btn.style.backgroundColor = "#25D366";
      btn.style.boxShadow = "0 2px 8px rgba(0,0,0,0.3)";
    }, 150);
  });

  // Responsividade
  function ajustarTamanho() {
    if (window.innerWidth < 600) {
      btn.querySelector("img").style.width = "50px";
      btn.querySelector("img").style.height = "50px";
      btn.style.bottom = "15px";
      btn.style.right = "15px";
    } else {
      btn.querySelector("img").style.width = "60px";
      btn.querySelector("img").style.height = "60px";
      btn.style.bottom = "20px";
      btn.style.right = "20px";
    }
  }

  window.addEventListener("resize", ajustarTamanho);
  ajustarTamanho();

  document.body.appendChild(btn);
</script>



<?php
require_once 'footer.php';
?>

