<?php
/**
 * Processamento do Formulário de Contato
 * Intimus RS - Sistema de Contatos
 */

require_once 'config.php';

// Verifica se o formulário foi enviado via POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    header('Location: contato.php?erro=metodo');
    exit;
}

// Função para limpar e validar dados
function limparDados($dado) {
    $dado = trim($dado);
    $dado = stripslashes($dado);
    $dado = htmlspecialchars($dado, ENT_QUOTES, 'UTF-8');
    return $dado;
}

// Função para validar telefone brasileiro
function validarTelefone($telefone) {
    // Remove caracteres não numéricos
    $telefone = preg_replace('/[^0-9]/', '', $telefone);
    
    // Verifica se tem 10 ou 11 dígitos (com DDD)
    if (strlen($telefone) < 10 || strlen($telefone) > 11) {
        return false;
    }
    
    return true;
}

// Captura e limpa os dados do formulário
$nome = isset($_POST['nome']) ? limparDados($_POST['nome']) : '';
$telefone = isset($_POST['telefone']) ? limparDados($_POST['telefone']) : '';
$endereco = isset($_POST['endereco']) ? limparDados($_POST['endereco']) : '';

// Validações básicas
$erros = [];

if (empty($nome)) {
    $erros[] = 'nome';
}

if (empty($telefone)) {
    $erros[] = 'telefone';
} elseif (!validarTelefone($telefone)) {
    header('Location: contato.php?erro=telefone');
    exit;
}

if (empty($endereco)) {
    $erros[] = 'endereco';
}

// Se houver erros de campos vazios, redireciona
if (!empty($erros)) {
    header('Location: contato.php?erro=campos');
    exit;
}

// Captura informações adicionais
$ip = getUserIP();
$origem_nav = getUserAgent();

try {
    // Conecta ao banco de dados
    $pdo = getDBConnection();
    
    // Prepara a query de inserção
    $sql = "INSERT INTO contatos (nome, telefone, endereco, origem_nav, ip) 
            VALUES (:nome, :telefone, :endereco, :origem_nav, :ip)";
    
    $stmt = $pdo->prepare($sql);
    
    // Bind dos parâmetros
    $stmt->bindParam(':nome', $nome, PDO::PARAM_STR);
    $stmt->bindParam(':telefone', $telefone, PDO::PARAM_STR);
    $stmt->bindParam(':endereco', $endereco, PDO::PARAM_STR);
    $stmt->bindParam(':origem_nav', $origem_nav, PDO::PARAM_STR);
    $stmt->bindParam(':ip', $ip, PDO::PARAM_STR);
    
    // Executa a inserção
    if ($stmt->execute()) {
        // Sucesso - redireciona com mensagem de sucesso
        header('Location: contato.php?sucesso=1');
        exit;
    } else {
        // Erro na execução
        error_log("Erro ao inserir contato no banco de dados");
        header('Location: contato.php?erro=sistema');
        exit;
    }
    
} catch (PDOException $e) {
    // Erro de banco de dados
    error_log("Erro PDO: " . $e->getMessage());
    header('Location: contato.php?erro=sistema');
    exit;
} catch (Exception $e) {
    // Erro genérico
    error_log("Erro: " . $e->getMessage());
    header('Location: contato.php?erro=sistema');
    exit;
}
?>

