// Animações e interatividade do site
document.addEventListener('DOMContentLoaded', function () {
    console.log('Site carregado e pronto!');
    
    // Fecha o menu mobile ao clicar em um link
    const menuCheckbox = document.getElementById('menu-toggle');
    const menuLinks = document.querySelectorAll('.main-nav a');
    
    if (menuCheckbox && menuLinks.length > 0) {
        menuLinks.forEach(link => {
            link.addEventListener('click', function() {
                menuCheckbox.checked = false;
            });
        });
    }
    
    // Animação de scroll (fade-in) usando Intersection Observer
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('fade-in-visible');
            }
        });
    }, {
        threshold: 0.1
    });

    // Observa todos os elementos com classe fade-in
    document.querySelectorAll('.fade-in').forEach(element => {
        observer.observe(element);
    });

    // Observa seções
    document.querySelectorAll('.section').forEach(section => {
        observer.observe(section);
    });

    // Animação de entrada para os passos do revendedor
    document.querySelectorAll('.step').forEach(step => {
        observer.observe(step);
    });

    // Smooth scroll para links internos
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function (e) {
            const href = this.getAttribute('href');
            
            // Ignora links vazios ou apenas "#"
            if (href === '#' || href === '') {
                return;
            }
            
            e.preventDefault();
            const target = document.querySelector(href);
            
            if (target) {
                // Fecha o menu mobile se estiver aberto
                if (menuCheckbox) {
                    menuCheckbox.checked = false;
                }
                
                target.scrollIntoView({
                    behavior: 'smooth',
                    block: 'start'
                });
            }
        });
    });
});

