<?php
/**
 * Teste de Conexão com o Banco de Dados
 * Use este arquivo para verificar se a conexão está funcionando
 */

echo "<h1>Teste de Conexão - Intimus RS</h1>";
echo "<hr>";

// Configurações
$host = 'localhost';
$user = 'root';
$pass = '';
$dbname = 'intimusrs_contatos';

echo "<h2>1. Testando conexão com MySQL (sem banco específico)...</h2>";

try {
    $pdo = new PDO("mysql:host=$host", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ <strong>Sucesso!</strong> Conectado ao MySQL.<br><br>";
    
    // Verifica se o banco existe
    echo "<h2>2. Verificando se o banco '$dbname' existe...</h2>";
    $stmt = $pdo->query("SHOW DATABASES LIKE '$dbname'");
    
    if ($stmt->rowCount() > 0) {
        echo "✅ <strong>Banco de dados encontrado!</strong><br><br>";
    } else {
        echo "⚠️ <strong>Banco de dados NÃO encontrado.</strong> Criando...<br>";
        $pdo->exec("CREATE DATABASE $dbname CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        echo "✅ <strong>Banco de dados criado com sucesso!</strong><br><br>";
    }
    
    // Conecta ao banco específico
    echo "<h2>3. Conectando ao banco '$dbname'...</h2>";
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $user, $pass);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✅ <strong>Conectado ao banco '$dbname'!</strong><br><br>";
    
    // Verifica tabelas
    echo "<h2>4. Verificando tabelas...</h2>";
    
    // Tabela contatos
    $stmt = $pdo->query("SHOW TABLES LIKE 'contatos'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabela 'contatos' existe<br>";
        $count = $pdo->query("SELECT COUNT(*) FROM contatos")->fetchColumn();
        echo "&nbsp;&nbsp;&nbsp;→ Total de registros: <strong>$count</strong><br>";
    } else {
        echo "⚠️ Tabela 'contatos' NÃO existe. Criando...<br>";
        $pdo->exec("CREATE TABLE contatos (
            id INT AUTO_INCREMENT PRIMARY KEY,
            nome VARCHAR(255) NOT NULL,
            telefone VARCHAR(50) NOT NULL,
            endereco VARCHAR(500) NOT NULL,
            origem_nav VARCHAR(500) DEFAULT NULL,
            data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
            data_updated DATETIME DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
            ip VARCHAR(45) DEFAULT NULL,
            INDEX idx_data_created (data_created),
            INDEX idx_nome (nome)
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        echo "✅ Tabela 'contatos' criada!<br>";
    }
    
    // Tabela usuarios_admin
    $stmt = $pdo->query("SHOW TABLES LIKE 'usuarios_admin'");
    if ($stmt->rowCount() > 0) {
        echo "✅ Tabela 'usuarios_admin' existe<br>";
        $count = $pdo->query("SELECT COUNT(*) FROM usuarios_admin")->fetchColumn();
        echo "&nbsp;&nbsp;&nbsp;→ Total de usuários: <strong>$count</strong><br>";
    } else {
        echo "⚠️ Tabela 'usuarios_admin' NÃO existe. Criando...<br>";
        $pdo->exec("CREATE TABLE usuarios_admin (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100) NOT NULL UNIQUE,
            password_hash VARCHAR(255) NOT NULL,
            nome VARCHAR(255) NOT NULL,
            data_created DATETIME DEFAULT CURRENT_TIMESTAMP,
            ultimo_acesso DATETIME DEFAULT NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci");
        
        // Insere usuário admin
        $pdo->exec("INSERT INTO usuarios_admin (username, password_hash, nome) 
                   VALUES ('admin', '\$2y\$10\$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrador')");
        echo "✅ Tabela 'usuarios_admin' criada e usuário admin inserido!<br>";
    }
    
    echo "<br><hr>";
    echo "<h2>✅ TUDO OK! Sistema pronto para uso.</h2>";
    echo "<p><strong>Próximos passos:</strong></p>";
    echo "<ul>";
    echo "<li>Acesse o formulário: <a href='contato.php'>contato.php</a></li>";
    echo "<li>Acesse o dashboard: <a href='admin/login.php'>admin/login.php</a></li>";
    echo "<li>Usuário: <strong>admin</strong> | Senha: <strong>admin123</strong></li>";
    echo "</ul>";
    echo "<br><p style='color: red;'><strong>⚠️ IMPORTANTE:</strong> Após verificar que está tudo funcionando, DELETE este arquivo (teste_conexao.php) por segurança!</p>";
    
} catch (PDOException $e) {
    echo "❌ <strong>ERRO:</strong> " . $e->getMessage() . "<br><br>";
    echo "<h3>Possíveis soluções:</h3>";
    echo "<ul>";
    echo "<li>Verifique se o MySQL/MariaDB está rodando no XAMPP</li>";
    echo "<li>Verifique se as credenciais estão corretas (usuário: root, senha: vazia)</li>";
    echo "<li>Verifique se a porta 3306 está disponível</li>";
    echo "<li>Tente reiniciar o Apache e MySQL no XAMPP</li>";
    echo "</ul>";
}
?>

