# Projeto: Intimus RS Atacado - Similar

## Visão Geral
Este projeto é uma recriação (similar) da página inicial do site **https://intimusrsatacado.com.br/**, desenvolvida utilizando a *stack* de **PHP Puro** (HTML, CSS e JavaScript) para demonstrar a estrutura, o estilo visual e as funcionalidades de animação solicitadas.

## Stack Tecnológica Utilizada
| Tecnologia | Versão | Propósito |
| :--- | :--- | :--- |
| **PHP** | Puro | Usado para incluir arquivos (`header.php`, `footer.php`) e estruturar a página principal (`index.php`), simulando um ambiente de servidor simples. |
| **HTML5** | Padrão | Estrutura semântica de todo o conteúdo da página. |
| **CSS3** | Padrão | Estilização, layout responsivo (Media Queries) e definição da paleta de cores. |
| **JavaScript** | Puro | Adição de interatividade e simulação de animações de *fade-in* ao rolar a página para elementos de seção. |
| **Font Awesome** | v6.5.2 (CDN) | Utilizado para os ícones que representam os benefícios e as chamadas para ação. |

## Principais Características Replicadas
O projeto focou em replicar os seguintes aspectos do site de referência:

1.  **Paleta de Cores**: Uso de uma cor **Primária** (Magenta Escuro) e **Secundária** (Magenta Mais Escuro) para botões, destaques e fundos de seção, mantendo a identidade visual.
2.  **Layout Responsivo**: O design foi construído para ser adaptável a diferentes tamanhos de tela (desktop, tablet e mobile) utilizando Flexbox e Grid CSS.
3.  **Estrutura de Seções**: O conteúdo está dividido em seções claras, como:
    *   Barra de Aviso Superior
    *   Cabeçalho com Navegação e Botão CTA
    *   Seção Principal (Hero) com overlay de cor.
    *   Seção de Benefícios (4 Colunas)
    *   Seção de Depoimentos (3 Colunas)
    *   Seção de Público-Alvo (Fundo Escuro)
    *   Seção de Início Rápido (3 Colunas)
    *   Seção Final de CTA
4.  **Animações**: Implementação de um efeito de **`fade-in`** (esmaecer e subir) em blocos de conteúdo ao entrar na área visível da tela, simulando as animações presentes no site original.

## Estrutura de Arquivos
```
.
├── assets/
│   └── hero-bg.jpg  // Imagem de fundo simulada
├── header.php       // Cabeçalho e início do HTML
├── footer.php       // Rodapé e fechamento do HTML
├── index.php        // Conteúdo principal (página inicial)
├── style.css        // Estilos CSS
└── script.js        // Lógica JavaScript (animações)
```

## Como Visualizar
Para visualizar o projeto, é necessário um ambiente com suporte a PHP (ex: XAMPP, WAMP, MAMP, ou um servidor web local).

1.  Descompacte o arquivo `intimusrs_similar.zip`.
2.  Coloque a pasta do projeto no diretório de documentos do seu servidor web.
3.  Acesse `index.php` através do seu navegador (ex: `http://localhost/nome_da_pasta/index.php`).

---
*Este arquivo foi criado após a entrega do projeto para documentação e referência futura.*
