// Futuras animações e interatividade podem ser adicionadas aqui.
document.addEventListener('DOMContentLoaded', function () {
    console.log('Site carregado e pronto!');
    
    // Simulação de animação de scroll (fade-in)
    const observer = new IntersectionObserver((entries) => {
        entries.forEach(entry => {
            if (entry.isIntersecting) {
                entry.target.classList.add('fade-in-visible');
            }
        });
    }, {
        threshold: 0.1
    });

    document.querySelectorAll('.section').forEach(section => {
        section.classList.add('fade-in');
        observer.observe(section);
    });

    // Animação de entrada para os passos do revendedor
    document.querySelectorAll('.step').forEach(step => {
        observer.observe(step);
    });
});
