from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Pedido
import os
from .ftp_util import enviar_ftp  # Importe a função de envio FTP (criada separadamente)
from .sftp_util import enviar_sftp

@receiver(post_save, sender=Pedido)
def gerar_arquivo_pedido(sender, instance, created, **kwargs):
    if instance.completo and not created:
        # Diretório onde o arquivo será salvo antes de enviar
        pedidos_dir = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'pedidos')
        os.makedirs(pedidos_dir, exist_ok=True)

        # Nome do arquivo
        nome_arquivo = os.path.join(pedidos_dir, f'pedido_{instance.id}.txt')

        with open(nome_arquivo, 'w', encoding='utf-8') as f:
            # Coletar todos os grupos únicos dos produtos do pedido
            grupos_set = set()
            
            # Produtos
            for item in instance.itempedido_set.all():
                produto = item.produto

                # Campos formatados conforme layout especificado
                # Código de barras: N 13 (Complementa zeros à esquerda)
                codigo_barras = str(produto.id).zfill(13)
                
                # Descrição do Produto: C 160 (Complementa Space à Direita)
                descricao = produto.nome[:160].ljust(160)
                
                # Valor do Produto: C 10 (Complementa zeros à esquerda) - em centavos
                valor = f"{int(produto.valor * 100):0>10}"
                
                # Estoque: C 10 (Complementa zeros à esquerda)
                estoque = str(produto.quantidade).zfill(10)
                
                # Unidade: C 4 (Complementa Space à Direita)
                unidade = (produto.ref or "")[:4].ljust(4)
                
                # Grupo do Produto: C 10 (Complementa zeros à esquerda)
                if produto.grupo:
                    grupo_codigo = produto.grupo.codigo[:9].zfill(9)
                    grupo_codigo = grupo_codigo.zfill(10)  # Ajusta para 10 caracteres
                    grupos_set.add(produto.grupo)
                else:
                    grupo_codigo = "0000000000"

                # Linha única no formato exato
                linha = f"{codigo_barras}{descricao}{valor}{estoque}{unidade}{grupo_codigo}\n"
                f.write(linha)
            
            # Layout Grupos
            # Adicionar informações dos grupos ao final do arquivo
            if grupos_set:
                f.write("\n")  # Separador entre produtos e grupos
                for grupo in grupos_set:
                    # Código do Grupo: C 9 (Complementa zeros à esquerda)
                    codigo_grupo = grupo.codigo[:9].zfill(9)
                    
                    # Nome do Grupo: C 100 (Complementa Space à Direita)
                    nome_grupo = grupo.nome[:100].ljust(100)
                    
                    # Linha do grupo
                    linha_grupo = f"{codigo_grupo}{nome_grupo}\n"
                    f.write(linha_grupo)

        # Enviar o arquivo via FTP após criação
        enviar_ftp(nome_arquivo)
        
        # Enviar o arquivo via SFTP 

        # enviar_sftp(nome_arquivo)



