from django import forms
from .models import Produto, Categoria

class CategoriaForm(forms.ModelForm):
    class Meta:
        model = Categoria
        fields = ["nome"]
        widgets = {
            'nome': forms.TextInput(attrs={'class': 'form-control', 'placeholder': 'Nome da categoria'}),
        }

class ProdutoForm(forms.ModelForm):
    class Meta:
        model = Produto
        fields = ["nome", "descricao", "quantidade", "valor", "imagem", "ref", "unidade_de_medida", "categoria"]
        labels = {
            'nome': 'Nome do Produto',
            'descricao': 'Descrição',
            'quantidade': 'Quantidade em Estoque',
            'valor': 'Valor (R$)',
            'imagem': 'Imagem do Produto',
            'ref': 'Referência',
            'unidade_de_medida': 'Unidade de Medida',
            'categoria': 'Categoria',
        }

