from django.urls import path
from . import views

urlpatterns = [
    path("", views.lista_produtos, name="lista_produtos"),
    path("criar/", views.criar_produto, name="criar_produto"),
    path("editar/<int:pk>/", views.editar_produto, name="editar_produto"),
    path("deletar/<int:pk>/", views.deletar_produto, name="deletar_produto"),
    
    # URLs para Categoria
    path("categorias/", views.lista_categorias, name="lista_categorias"),
    path("categorias/criar/", views.criar_categoria, name="criar_categoria"),
    path("categorias/criar-ajax/", views.criar_categoria_ajax, name="criar_categoria_ajax"),
    path("categorias/editar/<int:pk>/", views.editar_categoria, name="editar_categoria"),
    path("categorias/deletar/<int:pk>/", views.deletar_categoria, name="deletar_categoria"),
]


