from django import forms
from django.contrib.auth.forms import UserCreationForm, AuthenticationForm
from django.contrib.auth.models import User

class UserRegisterForm(UserCreationForm):
    email = forms.EmailField()

    class Meta:
        model = User
        fields = ["username", "email", "password"]

class UserLoginForm(AuthenticationForm):
    class Meta:
        model = User
        fields = ["username", "password"]

