from django.contrib import admin
from .models import Produto

class ProdutoAdmin(admin.ModelAdmin):
    list_display = (
        'nome',
        'quantidade',
        'valor',
        'ref',
        'usuario_cadastro',
        'data_criacao',
        'data_alteracao'
    )
    search_fields = ('nome', 'ref')
    list_filter = ('usuario_cadastro', 'data_criacao')

    def save_model(self, request, obj, form, change):
        if not obj.pk:
            obj.usuario_cadastro = request.user
        super().save_model(request, obj, form, change)

admin.site.register(Produto, ProdutoAdmin)

