from django.db import models
from django.contrib.auth.models import User

class Produto(models.Model):
    nome = models.CharField(max_length=255)
    descricao = models.TextField(blank=True, null=True)
    quantidade = models.IntegerField(default=0)
    valor = models.DecimalField(max_digits=10, decimal_places=2)
    imagem = models.ImageField(upload_to='produtos_imagens/', blank=True, null=True, default='produtos_imagens/placeholder.png')
    ref = models.CharField(max_length=100, unique=True, blank=True, null=True)
    usuario_cadastro = models.ForeignKey(User, on_delete=models.SET_NULL, null=True, blank=True, related_name='produtos_cadastrados')
    data_criacao = models.DateTimeField(auto_now_add=True)
    data_alteracao = models.DateTimeField(auto_now=True)

    class Meta:
        verbose_name = "Produto"
        verbose_name_plural = "Produtos"

    def __str__(self):
        return self.nome

