from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Pedido
from .models import Produto
import os
from .ftp_util import enviar_ftp  # Importe a função de envio FTP (criada separadamente)
from .sftp_util import enviar_sftp

@receiver(post_save, sender=Pedido)
def gerar_arquivo_pedido(sender, instance, created, **kwargs):
    if instance.completo and not created:
        # Diretório onde o arquivo será salvo antes de enviar
        pedidos_dir = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'pedidos')
        os.makedirs(pedidos_dir, exist_ok=True)

        # Nome do arquivo
        nome_arquivo = os.path.join(pedidos_dir, f'pedido_{instance.id}.txt')

        # Criação do conteúdo do pedido
        with open(nome_arquivo, 'w') as f:
            
            for item in instance.itempedido_set.all():
                f.write(f'{Produto.instance.ref}\n')
            f.write(f'\n\n')

        # Enviar o arquivo via FTP após criação
        enviar_ftp(nome_arquivo)
        
        # Enviar o arquivo via SFTP 

        # enviar_sftp(nome_arquivo)

