from django.db.models.signals import post_save
from django.dispatch import receiver
from .models import Pedido
import os
from .ftp_util import enviar_ftp  # Importe a função de envio FTP (criada separadamente)
from .sftp_util import enviar_sftp

@receiver(post_save, sender=Pedido)
def gerar_arquivo_pedido(sender, instance, created, **kwargs):
    if instance.completo and not created:
        # Diretório onde o arquivo será salvo antes de enviar
        pedidos_dir = os.path.join(os.path.dirname(os.path.abspath(__file__)), 'pedidos')
        os.makedirs(pedidos_dir, exist_ok=True)

        # Nome do arquivo
        nome_arquivo = os.path.join(pedidos_dir, f'pedido_{instance.id}.txt')

        with open(nome_arquivo, 'w', encoding='utf-8') as f:
            # Coletar todas as categorias únicas dos produtos do pedido
            categorias_set = set()
            
            # Produtos
            for item in instance.itempedido_set.all():
                produto = item.produto

                # Campos formatados conforme layout especificado
                # Código de barras: N 13 (Complementa zeros à esquerda)
                codigo_barras = str(produto.id).zfill(13)
                
                # Descrição do Produto: C 160 (Complementa Space à Direita)
                descricao = produto.nome[:160].ljust(160)
                
                # Valor do Produto: C 10 (Complementa zeros à esquerda) - em centavos
                valor = f"{int(produto.valor * 100):0>10}"
                
                # Estoque: C 10 (Complementa zeros à esquerda)
                estoque = str(produto.quantidade).zfill(10)
                
                # Unidade: C 4 (Complementa Space à Direita)
                unidade = (produto.ref or "")[:4].ljust(4)
                
                # Categoria do Produto: C 10 (Complementa zeros à esquerda)
                if produto.categoria:
                    categoria_codigo = str(produto.categoria.id).zfill(9)
                    categoria_codigo = categoria_codigo.zfill(10)  # Ajusta para 10 caracteres
                    categorias_set.add(produto.categoria)
                else:
                    categoria_codigo = "0000000000"

                # Linha única no formato exato
                linha = f"{codigo_barras}{descricao}{valor}{estoque}{unidade}{categoria_codigo}\n"
                f.write(linha)
            
            # Layout Categorias
            # Adicionar informações das categorias ao final do arquivo
            if categorias_set:
                f.write("\n")  # Separador entre produtos e categorias
                for categoria in categorias_set:
                    # Código da Categoria: C 9 (Complementa zeros à esquerda)
                    codigo_categoria = str(categoria.id).zfill(9)
                    
                    # Nome da Categoria: C 100 (Complementa Space à Direita)
                    nome_categoria = categoria.nome[:100].ljust(100)
                    
                    # Linha da categoria
                    linha_categoria = f"{codigo_categoria}{nome_categoria}\n"
                    f.write(linha_categoria)

        # Enviar o arquivo via FTP após criação
        enviar_ftp(nome_arquivo)
        
        # Enviar o arquivo via SFTP 

        # enviar_sftp(nome_arquivo)



